% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estDailyFromSurfacesJ.R
\name{estDailyFromSurfaces}
\alias{estDailyFromSurfaces}
\title{Estimates all daily values of Concentration, Flux, Flow-Normalized Concentration, and Flow Normalized Flux}
\usage{
estDailyFromSurfaces(eList)
}
\arguments{
\item{eList}{named list with at least the Daily and INFO dataframes, and the surface matrix}
}
\value{
egret object with altered Daily dataframe
}
\description{
Uses the surfaces estimated in estSurfaces to estimate these four time series
   in addition to the time series for standard error and yHat (estimated log concentration). 
   The results are stored in an augmented version of the Daily data frame, which is returned as part of an EGRET object.
}
\examples{
eList <- Choptank_eList
#################################################
# This is usually done in modelEstimation:
Daily <- getDaily(eList)
surfaceIndexParameters<-surfaceIndex(Daily)
INFO <- eList$INFO
INFO$bottomLogQ<-surfaceIndexParameters[1]
INFO$stepLogQ<-surfaceIndexParameters[2]
INFO$nVectorLogQ<-surfaceIndexParameters[3]
INFO$bottomYear<-surfaceIndexParameters[4]
INFO$stepYear<-surfaceIndexParameters[5]
INFO$nVectorYear<-surfaceIndexParameters[6]
eList$INFO <- INFO
#################################################
\dontrun{
Daily <- estDailyFromSurfaces(eList)
}
}
\keyword{statistics}
\keyword{water-quality}

