% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itemStability.R
\name{itemStability}
\alias{itemStability}
\title{Item Stability Statistics from \code{\link[EGAnet]{bootEGA}}}
\usage{
itemStability(bootega.obj, orig.wc, item.freq = 0.1,
  plot.item.rep = TRUE)
}
\arguments{
\item{bootega.obj}{A \code{\link[EGAnet]{bootEGA}} object}

\item{orig.wc}{Numeric or character.
A vector with community numbers or labels for each item.
Typically uses community results (\code{wc}) from \code{\link[EGAnet]{EGA}}}

\item{item.freq}{A value for lowest frequency allowed in \code{item.dim.rep} output.
Removes noise from table to allow for easier interpretation.
Defaults to \code{.10}}

\item{plot.item.rep}{Should the plot be produced for \code{item.replication}?
If \code{TRUE}, then a plot for the \code{item.replication} output will be produced.#'
Defaults to \code{TRUE}}
}
\value{
Returns a list containing:

\item{item.replication}{The proporton of times each item replicated
within the defined dimension}

\item{item.dim.rep}{The proportion of times each item replicated
within each possible dimension. Dimensions greater than the maximum
number used in the \code{orig.wc} argument are labeled based on the
largest remaining components after the dimensions used to \code{orig.wc}}

\item{item.loadings}{Matrix of the average standardied network loading
(computed using \code{\link[EGAnet]{net.loads}}) for each item in each dimension}

\item{wc}{A matrix containing the community membership values for
each bootstrapped sample. The values correspond to the values input
for the \code{orig.wc} argument}
}
\description{
Based on the \code{\link[EGAnet]{bootEGA}} results, this function
computes and plots the number of times an item (variable) is estimated
in the same factor/dimension as originaly estimated by \code{\link[EGAnet]{EGA}} (\code{item.replication}).
The output also contains each item's replication frequency (i.e., proprotion of
bootstraps that an item appeared in each dimension; \code{item.dim.rep}) as well as the average
network loading for each item in each dimension (\code{item.loadings}).
}
\examples{

# Load data
wmt <- wmt2[,7:24]

\dontrun{
# Estimate EGA network
ega.wmt <- EGA(data = wmt, model = "glasso")

# Estimate dimension stability
boot.wmt <- bootEGA(data = wmt, n = 100, typicalStructure = TRUE,
plot.typicalStructure = TRUE, model = "glasso",
type = "parametric", ncores = 4)

}

# Estimate item stability statistics
itemStability(boot.wmt, orig.wc = ega.wmt$wc)

}
\references{
Danon, L., Diaz-Guilera, A., Duch, J., & Arenas, A. (2005).
Comparing community structure identification.
\emph{Journal of Statistical Mechanics: Theory and Experiment}, \emph{9}, P09008.
<doi:10.1088/1742-5468/2005/09/P09008>
}
\seealso{
\code{\link[EGAnet]{EGA}} to estimate the number of dimensions of an instrument using EGA and
\code{\link[EGAnet]{CFA}} to verify the fit of the structure suggested by EGA using confirmatory factor analysis.
}
\author{
Hudson F. Golino <hfg9s at virginia.edu> and Alexander P. Christensen <alexpaulchristensen@gmail.com>
}
