% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itemIdent.R
\name{itemIdent}
\alias{itemIdent}
\title{Item Dimension Identification}
\usage{
itemIdent(bootega.obj, confirm, rep.val = 0.8, item.rep = 0.1)
}
\arguments{
\item{bootega.obj}{A \code{\link{bootEGA}} object}

\item{confirm}{A vector with community numbers or labels for each item}

\item{rep.val}{A replication value between 0 and 1. Items below this
value will be marked for their instability. It's recommended
to first run \code{\link{itemConfirm}} to determine appropriate cut-off
value.
Defaults to .80}

\item{item.rep}{A value for lowest likelihood allowed in \code{\link{itemConfirm}}'s \code{item.likelihood} output.
Removes noise from table to allow for easier interpretation.
Matches matrix to \code{\link{itemConfirm}} output.
Defaults to .10}
}
\value{
Returns a matrix of the unstandardized within- and between-community
strength values for each node
}
\description{
Computes the within- and between-community strength of each item
for each community. Based on \code{\link{itemConfirm}}, researchers can flag
items that are not replicating well to identify which communities they are
falling between.
}
\examples{
\donttest{
ega.wmt <- EGA(data = wmt2[,7:24], model = "glasso")

boot.wmt <- bootEGA(data = wmt2[,7:24], n = 100, typicalStructure = TRUE,
plot.typicalStructure = TRUE, model = "glasso",
type = "parametric", ncores = 4, confirm = ega.wmt$wc)

itemConfirm(boot.wmt, confirm = ega.wmt$wc, plot.ic = TRUE)

itemIdent(boot.wmt, confirm = ega.wmt$wc, rep.val = .80)
}

}
\author{
Hudson F. Golino <hfg9s at virginia.edu> and Alexander P. Christensen <alexpaulchristensen@gmail.com>
}
