% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.Hull}
\alias{plot.Hull}
\title{Plot Hull Plot for Factor Analysis}
\usage{
\method{plot}{Hull}(x, ...)
}
\arguments{
\item{x}{An object of class \code{Hull}, representing the results to be plotted.}

\item{...}{Additional arguments to be passed to the plotting function.}
}
\value{
None. This function is used for side effects (plotting).
}
\description{
This function creates a Hull plot to visualize the relationship between
the Comparative Fit Index (CFI) and the degrees of freedom (df) for a
range of models with different numbers of factors. The Hull plot helps
in assessing model fit and identifying optimal models.
}
\examples{
library(EFAfactors)
set.seed(123)

##Take the data.bfi dataset as an example.
data(data.bfi)

response <- as.matrix(data.bfi[, 1:25]) ## loading data
response <- na.omit(response) ## Remove samples with NA/missing values

## Transform the scores of reverse-scored items to normal scoring
response[, c(1, 9, 10, 11, 12, 22, 25)] <- 6 - response[, c(1, 9, 10, 11, 12, 22, 25)] + 1

\donttest{
 Hull.obj <- CD(response)

 ## Hull plot
 plot(Hull.obj)

}

}
\seealso{
\link[EFAfactors]{Hull}
}
