% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MHLS.R
\name{print.MHLS}
\alias{print.MHLS}
\title{Print Metropolis-Hastings sampler outputs}
\usage{
\method{print}{MHLS}(x, ...)
}
\arguments{
\item{x}{an object of class "MHLS", which is a result of \code{\link{MHLS}}.}

\item{...}{additional print arguments.}
}
\value{
Above results are silently returned.
}
\description{
Print a brief summary of the MH sampler outputs.
}
\details{
\code{\link{print.MHLS}} prints out last 10 iterations and a brief summary
of the simulation; number of iterations, number of burn-in periods, PE, PEtype and
acceptance rate.
}
\examples{
set.seed(123)
n <- 10
p <- 5
X <- matrix(rnorm(n * p), n)
Y <- X \%*\% rep(1, p) + rnorm(n)
sigma2 <- 1
lbd <- .37
weights <- rep(1, p)
LassoResult <- lassoFit(X = X, Y = Y, lbd = lbd, type="lasso", weights = weights)
B0 <- LassoResult$B0
S0 <- LassoResult$S0
Result <- MHLS(X = X, PE = rep(0, p), sig2 = sigma2, lbd = lbd, group = 1:p,
     weights = weights, B0 = B0, S0 = S0, niter = 50, burnin = 0,
     type = "coeff")
print(Result)
}
