% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LastOccur.R
\name{LastOccur}
\alias{LastOccur}
\title{LastOccur}
\usage{
LastOccur(x, y)
}
\arguments{
\item{x}{Dataframe or matix containing one sequence per row}

\item{y}{The value of interest}
}
\value{
returns a vector containing the index of the last 
event occurence for every row.
}
\description{
Returns index of last occurence: Each row is scanned for the last column in which a certain integer is shown. 
Consider the following example: one row has the values 1-2-2-1-0-4, last occurence of 0 would be the fith column,
last occurence of 1 would be the forth column, and so on.
}
\examples{
# Example 1: Small artificial data

 my.data<-matrix(c(1,0,1,1,
                   0,0,1,0,
                   1,0,0,0,
                   0,0,0,1),4,4, TRUE) # create data

 my.data # inspect sampe data
 LastOccur(my.data,1) # last Occurence of one
 LastOccur(my.data,0) # last Occurence of zero


# Example 2: Real data

 data(CouplesCope)
 LastOccur(CouplesCope[,2:49],1)

}
