% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseLargeScaleCharacteristics.R
\name{summariseCharacteristicsFromCodelist}
\alias{summariseCharacteristicsFromCodelist}
\title{Summarise a cohort from multipl codelist and windows}
\usage{
summariseCharacteristicsFromCodelist(
  cohort,
  cdm,
  conceptSet,
  strata = list(),
  window = list(c(-Inf, -366), c(-365, -31), c(-30, -1), c(0, 0), c(1, 30), c(31, 365),
    c(366, Inf)),
  overlap = TRUE,
  minCellCount = 5
)
}
\arguments{
\item{cohort}{Cohort to summarise}

\item{cdm}{cdm_reference}

\item{conceptSet}{A list of concept sets}

\item{strata}{Stratification list}

\item{window}{Windows to characterize}

\item{overlap}{Whether we consider episodes (overlap = TRUE) or incident
(overlap = FALSE)}

\item{minCellCount}{Minimum cell counts}
}
\value{
A SummarisedResults object that contains the characterization
}
\description{
Summarise a cohort from multipl codelist and windows
}
\examples{
\donttest{
library(DrugUtilisation)
library(CodelistGenerator)

cdm <- mockDrugUtilisation()

conceptSet <- list(
  "acetaminophen" = c(1125315, 1125360, 2905077, 43135274),
  "group A" = c(
    3665501, 378253, 317009, 761948, 1539403, 1503327, 1516980, 4141052,
    4313306
  )
)
summariseCharacteristicsFromCodelist(
  cdm[["cohort1"]], cdm, conceptSet,
  window = list(c(-365, -1), c(0, 0), c(1, 365))
)
}

}
