% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addIndication.R
\name{indicationToStrata}
\alias{indicationToStrata}
\title{Create new variables summarising the data of indication that can be used as
stratification columns}
\usage{
indicationToStrata(
  cohort,
  indicationVariables = indicationColumns(cohort),
  keep = FALSE
)
}
\arguments{
\item{cohort}{A cohort in the cdm}

\item{indicationVariables}{Indication variables that we want to join}

\item{keep}{Whether to keep the prior indication variables or not}
}
\value{
description The cohort with the new variable
}
\description{
Create new variables summarising the data of indication that can be used as
stratification columns
}
\examples{
\donttest{
library(DrugUtilisation)

cdm <- mockDrugUtilisation()
cdm[["cohort1"]] <- cdm[["cohort1"]] \%>\%
  addIndication(cdm, "cohort2") \%>\%
  indicationToStrata()
}

}
