% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDrugRecords.R
\name{getDrugRecords}
\alias{getDrugRecords}
\title{Drug exposure records for ingredients of interest}
\usage{
getDrugRecords(
  cdm,
  ingredient,
  includedConceptsTable,
  drugRecordsTable = "drug_exposure",
  exposureTypeId = NULL,
  tablePrefix = NULL,
  verbose = FALSE
)
}
\arguments{
\item{cdm}{CDMConnector reference object}

\item{ingredient}{Concept ID for ingredient of interest}

\item{includedConceptsTable}{includedConceptsTable}

\item{drugRecordsTable}{drugRecordsTable, default "drug_exposure"}

\item{exposureTypeId}{id of the drug exposure type to be filtered on (e.g. only prescribed).
By default all record types will be taken into account.}

\item{tablePrefix}{The stem for the permanent tables that will
be created when running the diagnostics. Permanent tables will be created using
this prefix, and any existing tables that start with this will be at risk of
being dropped or overwritten. If NULL, temporary tables will be
used throughout.}

\item{verbose}{verbose}
}
\value{
a table containing drug exposure records
}
\description{
Drug exposure records for ingredients of interest
}
