% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ufactors_function.R
\name{ufactors}
\alias{ufactors}
\title{This function generates the unique factors for a unique factor CCD.}
\usage{
ufactors(x)
}
\arguments{
\item{x}{a matrix of 0's and 1's indicating factor and response relationships.
Rows represent responses; columns represent factors. A 1 represents
that the factor for that column is related to the response for that row.}
}
\value{
numeric vector indicating unique factors
}
\description{
This function generates the unique factors for a unique factor CCD.
}
\examples{
#Response 1 is related to factors 1, 2, and 3
#Response 2 is related to factors 2, 3, and 4
#Response 3 is related to factors 1, 3, and 5
#Response 4 is related to factors 1 and 4
x<-matrix(c(1,1,1,0,0,
            0,1,1,1,0,
            1,0,1,0,1,
            1,0,0,1,0), nrow = 4,byrow = TRUE)
ufactors(x)
}
