% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiversityOccu.R
\name{batchoccu}
\alias{batchoccu}
\title{Fits occupancy models for multiple species detection history}
\usage{
batchoccu(pres, sitecov, obscov, spp, form, dredge = FALSE, pos = 1,
  envir = as.environment(pos))
}
\arguments{
\item{pres}{a data.frame where rows are the sites and columns are a series of
presence-absence observation from multiple species, every species needs to
have the same number of observations.}

\item{sitecov}{a data.frame where every row is a site, and every column is a
measurement of that site, such as elevation or slope, this covariates are
usually more constant.}

\item{obscov}{a list where every element is a data frame with the daily
covariates for each site, that is a measurement for each day, such as average
temperature of a day, this covariates are usually very .}

\item{spp}{the number of species in the pres data.frame}

\item{form}{a formula in the format ~ obscov ~ sitcov, the first arguments
will be used to calculate probability of detection and the second part the
occupancy.}

\item{dredge}{default = FALSE, if TRUE, for each species, the best occupancy
model will be determined by fitting all possible models and ranking by AICc.}

\item{pos}{where to do the removal. By default, uses the current environment.}

\item{envir}{the environment to use.}
}
\value{
A list with the fitted models for each species and the calculated
Alpha diversity for each site.
}
\description{
This function takes a data.frame with multiple detection history from
various species in different sites, covariates of each site to calculate
occupancy, variables specific to sampling days to calculate probability of
detection. It features an automatic model selection when dredge = TRUE.
}
\details{
This function fits the single season occupancy model of MacKenzie et al (2002),
for multiple species and it can automatically select the best model for each
specie based on AICc.
}
\examples{
\dontrun{
data("BatOccu")
data("Dailycov")
data("sampling.cov")
BatOccupancy <-batchoccu(pres = BatOccu, sitecov = sampling.cov, obscov =
Dailycov,spp = 17, form = ~ Julian + Meanhum + Meantemp + sdhum + sdtemp ~
Burn.intensity.soil + I(Burn.intensity.soil^2) + Burn.intensity.Canopy +
I(Burn.intensity.Canopy^2) + Burn.intensity.basal + I(Burn.intensity.basal^2))
#plot the response of occupancy to individual variables for species 4, 11
#and 15

responseplot.occu(batch = BatOccupancy, spp = 4, variable = Burn.intensity.soil)

responseplot.occu(batch = BatOccupancy, spp = 11, variable = Burn.intensity.soil)

responseplot.occu(batch = BatOccupancy, spp = 15, variable = Burn.intensity.soil)
}
#Dredge for 2 species
A <- batchoccu(pres = BatOccu[,1:6], sitecov = sampling.cov, obscov = Dailycov,
spp = 2, form = ~ Meanhum + Meantemp ~  Burn.intensity.basal +
I(Burn.intensity.basal^2), dredge = TRUE)
}
\author{
Derek Corcoran <derek.corcoran.barrios@gmail.com>
}
\seealso{
\code{\link[DiversityOccupancy]{diversityoccu}}
}

