% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_groups_by_number.R
\name{filter_groups_by_number}
\alias{filter_groups_by_number}
\title{Filter Group by Name}
\usage{
filter_groups_by_number(clusterised_object, group_number)
}
\arguments{
\item{clusterised_object}{An object created by the clusterise_sites function.}

\item{group_number}{A number that identifies the group to be extracted.}
}
\value{
A new clusterised object that only contains sites from the specified group.
}
\description{
Filter a clusterised object that has been assigned groups and remove groups that are not a specified label.
}
\examples{
# extract groups 3, 5, and 7 from a clusterised object
Colombia_Caquetá_dataframe <- subset(Colombia, stateProvince == "Caquetá")

clusterised_Caquetá <- clusterise_sites(dataframe = Colombia_Caquetá_dataframe,
                                       cluster_min_length = 30,
                                       group_radius = 20000
)

print(clusterised_Caquetá[[2]])

Colombia_Caquetá_3 <- filter_groups_by_number(clusterised_Caquetá, 3)
Colombia_Caquetá_5 <- filter_groups_by_number(clusterised_Caquetá, 5)
Colombia_Caquetá_7 <- filter_groups_by_number(clusterised_Caquetá, 7)

print(Colombia_Caquetá_3[[2]])
print(Colombia_Caquetá_5[[2]])
print(Colombia_Caquetá_7[[2]])
}
