% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copulaVis.R
\name{copulaVis}
\alias{copulaVis}
\title{Interactive copula visualization}
\usage{
copulaVis(copula, modules)
}
\arguments{
\item{copula}{Copula to visualize, presently one of :
\itemize{
 \item{"Independant": }{ Independant copula.}
 \item{"FrechetLowerBound": }{ Fréchet Lower Bound copula.}
 \item{"FrechetUpperBound": }{ Fréchet Upper Bound copula.}
 \item{"BivariateEFGM": }{ Eyraud-Farlie-Gumbel-Morgenstern copula.}
 \item{"Frechet": }{ Fréchet copula.}
 \item{"BivariateCA": }{ Bivariate Cuadras-Augé copula.}
 \item{"BivariateMO": }{ Bivariate Marhsall-Olkin copula.}
 \item{"BivariateAMH": }{ Bivariate Ali-Mikhail-Haq copula.}
 \item{"BivariateClayton": }{ Bivariate Clayton copula.}
 \item{"BivariateFrank": }{ Bivariate Frank copula.}
 \item{"BivariateGumbel": }{ Bivariate Gumbel copula.}
}}

\item{modules}{Vector of modules to visualize, one of :
\itemize{
 \item{"all": }{Renders all boxes.}
 \item{"simulationsPlot": }{Plot of simulations.}
 \item{"distributionPlot": }{Plot of distribution.}
}}
}
\value{
Launches Shiny application.
}
\description{
Opens an interactive Shiny app for the selected copula
and modules.
}
\examples{
## Only run this example in interactive R sessions
if (interactive()) {
   copulaVis(copula = "BivariateEFGM", modules = "distributionPlot")
}

}
