% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unif.R
\name{Unif}
\alias{Unif}
\alias{expValUnif}
\alias{varUnif}
\alias{kthMomentUnif}
\alias{expValLimUnif}
\alias{expValTruncUnif}
\alias{stopLossUnif}
\alias{meanExcessUnif}
\alias{VatRUnif}
\alias{TVatRUnif}
\alias{mgfUnif}
\title{Uniform Distribution}
\usage{
expValUnif(min = 0, max = 1)

varUnif(min = 0, max = 1)

kthMomentUnif(k, min = 0, max = 1)

expValLimUnif(d, min = 0, max = 1)

expValTruncUnif(d, min = 0, max = 1, less.than.d = TRUE)

stopLossUnif(d, min = 0, max = 1)

meanExcessUnif(d, min = 0, max = 1)

VatRUnif(kap, min = 0, max = 1)

TVatRUnif(kap, min = 0, max = 1)

mgfUnif(t, min = 0, max = 1)
}
\arguments{
\item{min}{lower and upper limits of the distribution.  Must be finite.}

\item{max}{lower and upper limits of the distribution.  Must be finite.}

\item{k}{kth-moment.}

\item{d}{cut-off value.}

\item{less.than.d}{logical; if \code{TRUE} (default) truncated mean for values <= d, otherwise, for values > d.}

\item{kap}{probability.}

\item{t}{t.}
}
\value{
Function :
  \itemize{
    \item{\code{\link{expValUnif}}}{ gives the expected value.}
    \item{\code{\link{varUnif}}}{ gives the variance.}
    \item{\code{\link{kthMomentUnif}}}{ gives the kth moment.}
    \item{\code{\link{expValLimUnif}}}{ gives the limited mean.}
    \item{\code{\link{expValTruncUnif}}}{ gives the truncated mean.}
    \item{\code{\link{stopLossUnif}}}{ gives the stop-loss.}
    \item{\code{\link{meanExcessUnif}}}{ gives the mean excess loss.}
    \item{\code{\link{VatRUnif}}}{ gives the Value-at-Risk.}
    \item{\code{\link{TVatRUnif}}}{ gives the Tail Value-at-Risk.}
  }
 Invalid parameter values will return an error detailing which parameter is problematic.
}
\description{
Uniform distribution with min \eqn{a} and max \eqn{b}.
}
\details{
The (continuous) uniform distribution with min and max parameters \eqn{a}
and \eqn{b} respectively has density:
  \deqn{f(x) = \frac{1}{b - a} \times \bm{1}_{\{x \in [a, b] \}}}{f(x) = 1 / (b - a) x 1_\{a <= x <= b\}}
for \eqn{x \in [a, b]}{a <= x <= b}.
}
\examples{
expValUnif(min = 3, max = 4)

varUnif(min = 3, max = 4)

kthMomentUnif(k = 2, min = 3, max = 4)

expValLimUnif(d = 3, min = 2, max = 4)

expValTruncUnif(d = 3, min = 2, max = 4)

# Values greather than d
expValTruncUnif(d = 3, min = 2, max = 4, less.than.d = FALSE)

stopLossUnif(d = 3, min = 2, max = 4)

meanExcessUnif(d = 2, min = 2, max = 4)

VatRUnif(kap = .99, min = 3, max = 4)

TVatRUnif(kap = .99, min = 3, max = 4)

mgfUnif(t = 2, min = 0, max = 1)

}
