% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_units.R
\name{convert_units}
\alias{convert_units}
\title{Convert units for abundance estimation}
\usage{
convert_units(distance_units, effort_units, area_units)
}
\arguments{
\item{distance_units}{units distances were measured in.}

\item{effort_units}{units that effort were measured in. Set as \code{NULL} for point transects.}

\item{area_units}{units for the prediction area.}
}
\description{
It is often the case that effort, distances and prediction area are collected in different units in the field. Functions in \code{Distance} allow for an argument to convert between these and provide an answer that makes sense. This function calculates that conversion factor, given knowledge of the units of the quantities used.
}
\details{
\code{convert_units} expects particular names for its inputs -- these should be singular names of the unit (e.g., "metre" rather than "metres"). You can view possible options with \code{\link{units_table}}. Both UK and US spellings are acceptable, case does not matter. For density estimation, area must still be provided ("objects per square ???"). Note that for cue counts (or other multiplier-based methods) one will still have to ensure that the rates are in the correct units for the survey.
}
\examples{
# distances measured in metres, effort in kilometres and
# abundance over an area measured in hectares:
convert_units("Metre", "Kilometre", "Hectare")

# all SI units, so the result is 1
convert_units("Metre", "metre", "square metre")

# for points ignore effort
convert_units("Metre", NULL, "Hectare")
}
\author{
David L Miller
}
