% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VisualFuns.R
\name{likert.heat.plot2}
\alias{likert.heat.plot2}
\title{Summary Heatmap for categorical/Likert data
Heatmap representation summarizing categorical/likert data.
Modified version of `likert.heat.plot` from `likert` package.
Does not allow different categorical ranges across questions.
The function outputs a ggplot object where additional layers can be added for customization purposes.
The output plot preserves the question order given by columns of `x`.}
\usage{
likert.heat.plot2(
  x,
  allLevels,
  low.color = "white",
  high.color = "blue",
  text.color = "black",
  text.size = 4,
  textLen = 50
)
}
\arguments{
\item{x}{matrix object or data.frame with categorical data. Columns are questions and rows are observations.}

\item{allLevels}{vector with all categorical (ordered) levels.}

\item{low.color}{string; name of color assigned to the first level found in `allLevels`.}

\item{high.color}{string; name of color assigned to the last level found in `allLevels`.}

\item{text.color}{string; text color of numbers within cells.}

\item{text.size}{string; text size for numbers within cells.}

\item{textLen}{string; maximum length of text-length for question labels (column names)}
}
\value{
ggplot object.
}
\description{
Summary Heatmap for categorical/Likert data
Heatmap representation summarizing categorical/likert data.
Modified version of `likert.heat.plot` from `likert` package.
Does not allow different categorical ranges across questions.
The function outputs a ggplot object where additional layers can be added for customization purposes.
The output plot preserves the question order given by columns of `x`.
}
