% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{Vectorize.function}
\alias{Vectorize.function}
\title{Vectorize a multidimensional Function}
\usage{
Vectorize.function(fund, dim, .apply = base::apply)
}
\arguments{
\item{fund}{'dim'-dimensional function to Vectorize}

\item{dim}{dimension of input arguments of fund}

\item{.apply}{which vectorization to use (default is base::apply)}
}
\value{
a vectorized function (to be called on matrix argument, on each row)
}
\description{
Vectorize a d-dimensional (input) function, in the same way that base::Vectorize for 1-dimensional functions.
}
\examples{
f = function(x)x[1]+1; f(1:10); F = Vectorize.function(f,1);
F(1:10); #F = Vectorize(f); F(1:10);

f2 = function(x)x[1]+x[2]; f2(1:10); F = Vectorize.function(f2,2);
F(cbind(1:10,11:20)); #F = Vectorize(f); F(1:10);
}
