% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_node_df.R
\name{create_node_df}
\alias{create_node_df}
\title{Create a node data frame}
\usage{
create_node_df(n, type = NULL, label = NULL, ...)
}
\arguments{
\item{n}{The total number of nodes to include in the node data frame.}

\item{type}{An optional \code{type} for each node.}

\item{label}{An optional \code{label} for each node.}

\item{...}{One or more vectors for associated node attributes.}
}
\value{
A node data frame (ndf).
}
\description{
Combine several vectors for nodes and their attributes into a data frame,
which can be combined with other similarly-generated data frames, or, added
to a graph object. A node data frame, or ndf, has at least the following
columns:
\itemize{
\item \code{id} (of type \code{integer})
\item \code{type} (of type \code{character})
\item \code{label} (of type \code{character})
}

An arbitrary number of additional columns containing aesthetic or data
attributes can be part of the ndf, so long as they follow the aforementioned
columns.
}
\examples{
# Create a node data frame (ndf) where the labels
# are equivalent to the node ID values (this is not
# recommended); the `label` and `type` node
# attributes will always be a `character` class
# whereas `id` will always be an `integer`
node_df <-
  create_node_df(
    n = 4,
    type = c("a", "a", "b", "b"),
    label = TRUE)

# Display the node data frame
node_df

# Create an ndf with distinct labels and
# additional node attributes (where their classes
# will be inferred from the input vectors)
node_df <-
  create_node_df(
    n = 4,
    type = "a",
    label = c(2384, 3942, 8362, 2194),
    style = "filled",
    color = "aqua",
    shape = c("circle", "circle",
              "rectangle", "rectangle"),
    value = c(3.5, 2.6, 9.4, 2.7))

# Display the node data frame
node_df

}
\seealso{
Other Node creation and removal: 
\code{\link{add_n_node_clones}()},
\code{\link{add_n_nodes_ws}()},
\code{\link{add_n_nodes}()},
\code{\link{add_node_clones_ws}()},
\code{\link{add_node_df}()},
\code{\link{add_nodes_from_df_cols}()},
\code{\link{add_nodes_from_table}()},
\code{\link{add_node}()},
\code{\link{colorize_node_attrs}()},
\code{\link{copy_node_attrs}()},
\code{\link{delete_nodes_ws}()},
\code{\link{delete_node}()},
\code{\link{drop_node_attrs}()},
\code{\link{join_node_attrs}()},
\code{\link{layout_nodes_w_string}()},
\code{\link{mutate_node_attrs_ws}()},
\code{\link{mutate_node_attrs}()},
\code{\link{node_data}()},
\code{\link{recode_node_attrs}()},
\code{\link{rename_node_attrs}()},
\code{\link{rescale_node_attrs}()},
\code{\link{set_node_attr_to_display}()},
\code{\link{set_node_attr_w_fcn}()},
\code{\link{set_node_attrs_ws}()},
\code{\link{set_node_attrs}()},
\code{\link{set_node_position}()}
}
\concept{Node creation and removal}
