% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_global_graph_attrs.R
\name{delete_global_graph_attrs}
\alias{delete_global_graph_attrs}
\title{Delete one of the global graph attributes stored
within a graph object}
\usage{
delete_global_graph_attrs(graph, attr, attr_type)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{attr}{the name of the attribute to
delete for the \code{type} of global attribute
specified.}

\item{attr_type}{the specific type of global graph
attribute to delete. The type is specified with
\code{graph}, \code{node}, or \code{edge}.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
Delete one of the global attributes
stored within a graph object of class
\code{dgr_graph}).
}
\examples{
# Create a new graph and add some global attributes
graph <-
  create_graph() \%>\%
  add_global_graph_attrs(
    attr = "overlap",
    value = "true",
    attr_type = "graph") \%>\%
  add_global_graph_attrs(
    attr = "penwidth",
    value = 3,
    attr_type = "node") \%>\%
  add_global_graph_attrs(
    attr = "penwidth",
    value = 3,
    attr_type = "edge")

# View the graph's global attributes
get_global_graph_attrs(graph)
#>       attr value attr_type
#> 1  overlap  true     graph
#> 2 penwidth     3      node
#> 3 penwidth     3      edge

# Delete the `penwidth` attribute for the graph's
# nodes using `delete_global_graph_attrs()`
graph <-
  graph \%>\%
  delete_global_graph_attrs(
    attr = "penwidth",
    attr_type = "node")

# View the remaining set of global
# attributes for the graph
get_global_graph_attrs(graph)
#>       attr value attr_type
#> 1 penwidth     3      edge
#> 2  overlap  true     graph
}
