% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_degree_histogram.R
\name{get_degree_histogram}
\alias{get_degree_histogram}
\title{Get histogram data for a graph's degree frequency}
\usage{
get_degree_histogram(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}
}
\value{
a named vector of degree counts (with
bin width equal to 1) where the degree values
serve as names.
}
\description{
Get histogram data for a graph's
degree frequency. The bin width is set to 1 and
zero-value degrees are omitted from the output.
}
\examples{
# Create a random, directed graph with 18 nodes
# and 22 edges
graph <-
  create_random_graph(
    n = 18, m = 22,
    set_seed = 23)

# Get degree histogram data for `random_graph`
graph \%>\% get_degree_histogram()
#> 0 1 2 3 4
#> 1 4 4 4 5
}

