% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/is_graph_directed.R
\name{is_graph_directed}
\alias{is_graph_directed}
\title{Is the graph a directed graph?}
\usage{
is_graph_directed(graph)
}
\arguments{
\item{graph}{a graph object of class \code{dgr_graph}.}
}
\value{
a logical value.
}
\description{
Determines whether a graph is set to be directed or not and
returns a logical value to that effect.
}
\examples{
\dontrun{
# Create a graph with nodes and edges
nodes <-
  create_nodes(nodes = c("a", "b", "c", "d"))

edges <-
  create_edges(from = c("a", "b", "c"),
               to = c("d", "c", "a"))

graph <-
  create_graph(nodes_df = nodes,
               edges_df = edges)

# Determine whether the graph is directed
is_graph_directed(graph)
#> [1] TRUE
}
}

