% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/series_info.R
\name{series_info}
\alias{series_info}
\title{Get information on a graph series}
\usage{
series_info(graph_series)
}
\arguments{
\item{graph_series}{a graph series object of type
\code{dgr_graph_1D}.}
}
\value{
a data frame containing information on the
graphs within the supplied graph series.
}
\description{
Obtain a data frame with information
on the graphs within a graph series.
}
\examples{
library(magrittr)

# Create three graphs
graph_1 <-
  create_graph() \%>\%
  add_node("a") \%>\%
  add_node("b") \%>\%
  add_node("c") \%>\%
  add_edge("a", "c") \%>\%
  add_edge("a", "b") \%>\%
  add_edge("b", "c")

graph_2 <-
  graph_1 \%>\%
  add_node("d") \%>\%
  add_edge("d", "c")

graph_3 <-
  graph_2 \%>\%
  add_node("e") \%>\%
  add_edge("e", "b")

# Create an empty graph series and add
# the graphs
series <-
  create_series() \%>\%
  add_to_series(graph_1, .) \%>\%
  add_to_series(graph_2, .) \%>\%
  add_to_series(graph_3, .)

# Get information on the graphs in the series
series_info(series)
#>   graph name date_time   tz nodes edges directed
#> 1     1 <NA>      <NA> <NA>     3     3     TRUE
#> 2     2 <NA>      <NA> <NA>     4     4     TRUE
#> 3     3 <NA>      <NA> <NA>     5     5     TRUE
}

