% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_node_attrs.R
\name{get_node_attrs}
\alias{get_node_attrs}
\title{Get node attribute values}
\usage{
get_node_attrs(x, node_attr, nodes = NULL)
}
\arguments{
\item{x}{either a graph object of class
\code{dgr_graph} that is created using
\code{create_graph}, or a node data frame.}

\item{node_attr}{the name of the attribute for which
to get values.}

\item{nodes}{an optional vector of node IDs for
filtering list of nodes present in the graph or
node data frame.}
}
\value{
a named vector of node attribute values for
the attribute given by \code{node_attr} by node ID.
}
\description{
From a graph object of class
\code{dgr_graph} or a node data frame, get node
attribute values for one or more nodes.
}
\examples{
library(magrittr)

# With the `create_random_graph()` function, get
# a simple graph with a node attribute called
# `value`
random_graph <-
  create_random_graph(
    n = 4,
    m = 4,
    directed = TRUE,
    fully_connected = TRUE,
    set_seed = 20)

# Get all of the values from the `value` node
# attribute as a named vector
random_graph \%>\%
  get_node_attrs("value")
#> 1   2   3   4
#> 9.0 8.0 3.0 5.5

# To only return node attribute values for specified
# nodes, use the `nodes` argument
random_graph \%>\%
  get_node_attrs("value", nodes = c(1, 3))
#> 1 3
#> 9 3
}

