% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/V_Av..R
\name{V_Av.}
\alias{V_Av.}
\title{Reserve Valuation for Varying Life Insurance: Arithmetic Progression}
\usage{
V_Av.(
  px,
  x,
  h,
  n,
  k = 1,
  r,
  cantprem = 1,
  premperyear = 1,
  i = 0.04,
  data,
  prop = 1,
  assumption = "none",
  variation = "none",
  cap,
  t
)
}
\arguments{
\item{px}{A numeric value. The value of the premium paid in each period.}

\item{x}{An integer. The age of the insuree.}

\item{h}{An integer. The deferral period.}

\item{n}{An integer. Number of years of coverage.}

\item{k}{An integer. Number of fractions per year.}

\item{r}{The variation rate. A numeric type value.}

\item{cantprem}{An integer. The total number of premiums.}

\item{premperyear}{An integer. The number of premiums to be paid per year.}

\item{i}{The interest rate. A numeric type value.}

\item{data}{A data.frame containing the mortality table, with the first column being the age and the second one, the probability of death.}

\item{prop}{A numeric value. It represents the proportion of the mortality table used (between 0 and 1).}

\item{assumption}{A character string. The assumption used for fractional ages ("UDD" for uniform distribution of deaths, "constant" for constant force of mortality and "none" if there is no fractional coverage).}

\item{variation}{A character string. "inter" if the variation it's interannual or "intra" if it's intra-annual.}

\item{cap}{A numeric type value. Amount insured for the first year/period.}

\item{t}{An integer. The moment of valuation (in months if it is a fractional coverage or in years if it is not).}
}
\value{
A data frame with Premium, Risk, 1/E and reserve values up to the moment t.
}
\description{
Calculates the reserve for the varying life insurance up to the moment t.
}
\examples{
V_Av.(333.373580168544,20,2,2,1,0.05,1,1,0.04,CSO80MANB,1,"none","none",100000,4)
V_Av.(175.054867728107/12,20,2,2,2,0.05,24,12,0.04,CSO80MANB,1,"UDD","inter",100000,48)
V_Av.(183.436285298212/12,20,2,2,2,0.05,24,12,0.04,CSO80MANB,1,"UDD","intra",100000,48)
V_Av.(183.965812992762/12,20,2,2,2,0.05,24,12,0.04,CSO80MANB,1,"constant","intra",100000,48)
V_Av.(174.645127871177/12,20,2,2,2,0.05,24,12,0.04,CSO80MANB,1,"constant","inter",100000,48)


}
\references{
Chapter 5 of  Life Contingencies (1952) by Jordan, Chapter 11 of  Actuarial Mathematics for Life Contingent Risks (2009) by Dickson, Hardy and Waters.
}
\keyword{Arithmetic}
\keyword{Insurance}
\keyword{Life}
\keyword{Progression}
\keyword{Reserve}
\keyword{Varying}
