% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlierWH.R
\name{outlierWH}
\alias{outlierWH}
\title{Outliers detection}
\usage{
outlierWH(x, lower = NULL, upper = NULL, dec = NULL)
}
\arguments{
\item{x}{Numeric. A vector of the data set.}

\item{lower}{Numeric. A value representing the lower limit of outliers.}

\item{upper}{Numeric. A value representing the upper limit of outliers.}

\item{dec}{Numeric. A value to define the decimal numbers}
}
\value{
A list including three elements: 1) A data frame including the mean, the standart deviation, and
the upper and lower limits of outliers, 2) A numeric vector with data considered no outliers, and 2) A numeric
vector including the putative outliers.
}
\description{
The function used to detect atypical values in a data set
}
\details{
This function shows a list with the putative outliers and other without those.
If you do not type lower and upper values, by default the value is assumed as the standard deviation
of "x" multipied two.
}
\examples{
#Example 1
data=rnorm(100,30,15)
outlierWH( x=data ,lower=15 ,upper=35 )
#Example 2
outlierWH( x=data )
#Example 3
outlierWH( x=data ,lower=15 )
}
