/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.menu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPLogical;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.toolkit.DJList;
import org.rosuda.deducer.toolkit.HelpButton;
import org.rosuda.deducer.toolkit.IconButton;
import org.rosuda.deducer.toolkit.OkayCancelPanel;
import org.rosuda.deducer.toolkit.VariableSelector;

public class DescriptivesDialog
extends JDialog
implements ActionListener {
    private JPanel firstPanel;
    private DJList strataList;
    private JButton cont;
    private IconButton addStrata;
    private OkayCancelPanel okCancel;
    private IconButton removeStrata;
    private IconButton removeDesc;
    private IconButton addDesc;
    private JScrollPane strataScroller;
    private JPanel strataPanel;
    private JPanel descPanel;
    private DJList descrList;
    private JScrollPane descScroller;
    private VariableSelector variableSelector;
    private JPanel secondPanel;
    private JPanel functionPanel;
    private IconButton addFunc;
    private DJList runFuncList;
    private DJList functionList;
    private JScrollPane runFuncScroller;
    private JButton custom;
    private JPanel runFuncPanel;
    private IconButton removeFunc;
    private JScrollPane functionScroller;
    private HelpButton help;
    private static String[] functions = new String[]{"Mean", "St. Deviation", "Valid N", "Median", "25th Percentile", "75th Percentile", "Minimum", "Maximum", "Skew", "Kurtosis"};
    private static DefaultListModel lastDescrModel;
    private static DefaultListModel lastStrataModel;
    private static DefaultListModel lastFuncModel;
    private static String lastDataName;

    public DescriptivesDialog(JFrame jFrame) {
        super(jFrame);
        this.initGUI();
    }

    private void initGUI() {
        try {
            AnchorLayout anchorLayout = new AnchorLayout();
            this.getContentPane().setLayout((LayoutManager)anchorLayout);
            this.setTitle("Descriptives");
            this.okCancel = new OkayCancelPanel(true, false, this);
            this.getContentPane().add((Component)this.okCancel, new AnchorConstraint(869, 942, 947, 400, 1, 1, 1, 1));
            this.cont = this.okCancel.getApproveButton();
            this.cont.setText("Continue");
            this.help = new HelpButton("pmwiki.php?n=Main.Descriptives");
            this.getContentPane().add((Component)this.help, new AnchorConstraint(869, 942, 947, 25, 0, 0, 1, 1));
            this.help.setPreferredSize(new Dimension(32, 32));
            this.initFirstPanel();
            this.initSecondPanel();
            boolean bl = false;
            if (lastDataName != null) {
                this.variableSelector.setSelectedData(lastDataName);
            }
            if (lastDescrModel != null && lastDescrModel.getSize() != 0) {
                this.descrList.setModel(lastDescrModel);
                boolean bl2 = bl = !this.variableSelector.removeAll(lastDescrModel);
            }
            if (lastStrataModel != null && lastStrataModel.getSize() != 0) {
                this.strataList.setModel(lastStrataModel);
                boolean bl3 = bl = bl || !this.variableSelector.removeAll(lastStrataModel);
            }
            if (lastFuncModel != null && lastFuncModel.getSize() != 0) {
                this.runFuncList.setModel(lastFuncModel);
                DefaultListModel defaultListModel = (DefaultListModel)this.functionList.getModel();
                for (int i = 0; i < lastFuncModel.getSize(); ++i) {
                    defaultListModel.removeElement(lastFuncModel.get(i));
                }
            }
            if (bl) {
                this.variableSelector.reset();
                this.strataList.setModel(new DefaultListModel());
                this.descrList.setModel(new DefaultListModel());
            }
            this.secondPanel.setVisible(false);
            this.setMinimumSize(new Dimension(400, 400));
            this.setSize(524, 443);
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    private void initFirstPanel() {
        this.firstPanel = new JPanel();
        AnchorLayout anchorLayout = new AnchorLayout();
        this.getContentPane().add((Component)this.firstPanel, new AnchorConstraint(-1, 1000, 812, 0, 1, 1, 1, 1));
        this.firstPanel.setLayout((LayoutManager)anchorLayout);
        this.firstPanel.setPreferredSize(new Dimension(516, 333));
        this.addDesc = new IconButton("/icons/1rightarrow_32.png", "Add", this, "Add");
        this.firstPanel.add((Component)this.addDesc, new AnchorConstraint(176, 543, 286, 462, 1, 1, 1, 1));
        this.addDesc.setPreferredSize(new Dimension(42, 33));
        this.strataPanel = new JPanel();
        BorderLayout borderLayout = new BorderLayout();
        this.strataPanel.setLayout(borderLayout);
        this.firstPanel.add((Component)this.strataPanel, new AnchorConstraint(623, 950, 920, 564, 1, 1, 1, 1));
        this.strataPanel.setPreferredSize(new Dimension(199, 99));
        this.strataPanel.setBorder(BorderFactory.createTitledBorder("Stratify By:"));
        this.strataScroller = new JScrollPane();
        this.strataPanel.add((Component)this.strataScroller, "Center");
        DefaultListModel defaultListModel = new DefaultListModel();
        this.strataList = new DJList();
        this.strataScroller.setViewportView(this.strataList);
        this.strataList.setModel(defaultListModel);
        this.descPanel = new JPanel();
        borderLayout = new BorderLayout();
        this.descPanel.setLayout(borderLayout);
        this.firstPanel.add((Component)this.descPanel, new AnchorConstraint(37, 956, 605, 564, 1, 1, 1, 1));
        this.descPanel.setPreferredSize(new Dimension(202, 189));
        this.descPanel.setBorder(BorderFactory.createTitledBorder("Descriptives of:"));
        this.descScroller = new JScrollPane();
        this.descPanel.add(this.descScroller);
        defaultListModel = new DefaultListModel();
        this.descrList = new DJList();
        this.descScroller.setViewportView(this.descrList);
        this.descrList.setModel(defaultListModel);
        this.variableSelector = new VariableSelector();
        this.firstPanel.add((Component)this.variableSelector, new AnchorConstraint(37, 429, 920, 24, 1, 1, 1, 1));
        this.variableSelector.setPreferredSize(new Dimension(209, 294));
        this.variableSelector.setBorder(BorderFactory.createEtchedBorder(1));
        this.variableSelector.getJComboBox().addActionListener(this);
        this.removeDesc = new IconButton("/icons/1leftarrow_32.png", "Remove", this, "Remove");
        this.firstPanel.add((Component)this.removeDesc, new AnchorConstraint(301, 543, 411, 462, 1, 1, 1, 1));
        this.removeDesc.setPreferredSize(new Dimension(42, 42));
        this.addStrata = new IconButton("/icons/1rightarrow_32.png", "Add Strata", this, "Add Strata");
        this.firstPanel.add((Component)this.addStrata, new AnchorConstraint(681, 543, 791, 462, 1, 1, 1, 1));
        this.addStrata.setPreferredSize(new Dimension(42, 42));
        this.removeStrata = new IconButton("/icons/1leftarrow_32.png", "Remove Strata", this, "Remove Strata");
        this.firstPanel.add((Component)this.removeStrata, new AnchorConstraint(806, 543, 916, 462, 1, 1, 1, 1));
        this.removeStrata.setPreferredSize(new Dimension(42, 33));
    }

    private void initSecondPanel() {
        this.secondPanel = new JPanel();
        AnchorLayout anchorLayout = new AnchorLayout();
        this.getContentPane().add((Component)this.secondPanel, new AnchorConstraint(-1, 1000, 812, 0, 1, 1, 1, 1));
        this.secondPanel.setLayout((LayoutManager)anchorLayout);
        this.secondPanel.setPreferredSize(new Dimension(516, 333));
        this.custom = new JButton();
        this.secondPanel.add((Component)this.custom, new AnchorConstraint(811, 901, 886, 695, 1, 1, 1, 1));
        this.custom.setText("Custom");
        this.custom.setPreferredSize(new Dimension(93, 21));
        this.custom.addActionListener(this);
        this.runFuncPanel = new JPanel();
        BorderLayout borderLayout = new BorderLayout();
        this.runFuncPanel.setLayout(borderLayout);
        this.secondPanel.add((Component)this.runFuncPanel, new AnchorConstraint(44, 974, 767, 629, 1, 1, 1, 1));
        this.runFuncPanel.setPreferredSize(new Dimension(156, 201));
        this.runFuncPanel.setBorder(BorderFactory.createTitledBorder("Run Descriptives"));
        this.runFuncScroller = new JScrollPane();
        this.runFuncPanel.add((Component)this.runFuncScroller, "Center");
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        defaultListModel.addElement("Mean");
        defaultListModel.addElement("St. Deviation");
        defaultListModel.addElement("Valid N");
        this.runFuncList = new DJList();
        this.runFuncScroller.setViewportView(this.runFuncList);
        this.runFuncList.setModel(defaultListModel);
        this.removeFunc = new IconButton("/icons/1leftarrow_32.png", "Remove Function", this, "Remove Function");
        this.secondPanel.add((Component)this.removeFunc, new AnchorConstraint(321, 574, 437, 478, 1, 1, 1, 1));
        this.removeFunc.setPreferredSize(new Dimension(43, 32));
        this.addFunc = new IconButton("/icons/1rightarrow_32.png", "Add Function", this, "Add Function");
        this.secondPanel.add((Component)this.addFunc, new AnchorConstraint(188, 574, 303, 478, 1, 1, 1, 1));
        this.addFunc.setPreferredSize(new Dimension(43, 32));
        this.functionPanel = new JPanel();
        borderLayout = new BorderLayout();
        this.secondPanel.add((Component)this.functionPanel, new AnchorConstraint(44, 421, 886, 27, 1, 1, 1, 1));
        this.functionPanel.setLayout(borderLayout);
        this.functionPanel.setPreferredSize(new Dimension(178, 234));
        this.functionPanel.setBorder(BorderFactory.createTitledBorder("Functions"));
        this.functionScroller = new JScrollPane();
        this.functionPanel.add((Component)this.functionScroller, "Center");
        defaultListModel = new DefaultListModel();
        for (int i = 3; i < functions.length; ++i) {
            defaultListModel.addElement(functions[i]);
        }
        this.functionList = new DJList();
        this.functionScroller.setViewportView(this.functionList);
        this.functionList.setModel(defaultListModel);
    }

    public void setDataName(String string, boolean bl) {
        if (!string.equals(this.variableSelector.getSelectedData())) {
            this.variableSelector.setSelectedData(string);
            if (bl) {
                this.reset();
            }
        }
    }

    public void reset() {
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        this.runFuncList.setModel(defaultListModel);
        defaultListModel.addElement("Mean");
        defaultListModel.addElement("St. Deviation");
        defaultListModel.addElement("Valid N");
        DefaultListModel<String> defaultListModel2 = new DefaultListModel<String>();
        this.functionList.setModel(defaultListModel2);
        for (int i = 3; i < functions.length; ++i) {
            defaultListModel2.addElement(functions[i]);
        }
        ((DefaultListModel)this.strataList.getModel()).removeAllElements();
        ((DefaultListModel)this.descrList.getModel()).removeAllElements();
        this.variableSelector.reset();
        this.secondPanel.setVisible(false);
        this.cont.setText("Continue");
        this.firstPanel.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "comboBoxChanged") {
            this.descrList.setModel(new DefaultListModel());
            this.strataList.setModel(new DefaultListModel());
        } else if (string == "Continue") {
            if (this.descrList.getModel().getSize() == 0) {
                JOptionPane.showMessageDialog(this, "Please choose a variable");
                return;
            }
            this.firstPanel.setVisible(false);
            this.secondPanel.setVisible(true);
            this.cont.setText("Run");
        } else if (string == "Cancel") {
            this.dispose();
        } else if (string == "Add") {
            Object[] objectArray = this.variableSelector.getJList().getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                this.variableSelector.remove(objectArray[i]);
                ((DefaultListModel)this.descrList.getModel()).addElement(objectArray[i]);
            }
        } else if (string == "Remove") {
            Object[] objectArray = this.descrList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                this.variableSelector.add(objectArray[i]);
                ((DefaultListModel)this.descrList.getModel()).removeElement(objectArray[i]);
            }
        } else if (string == "Add Strata") {
            Object[] objectArray = this.variableSelector.getJList().getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                this.variableSelector.remove(objectArray[i]);
                ((DefaultListModel)this.strataList.getModel()).addElement(objectArray[i]);
            }
        } else if (string == "Remove Strata") {
            Object[] objectArray = this.strataList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                this.variableSelector.add(objectArray[i]);
                ((DefaultListModel)this.strataList.getModel()).removeElement(objectArray[i]);
            }
        } else if (string == "Add Function") {
            Object[] objectArray = this.functionList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                ((DefaultListModel)this.functionList.getModel()).removeElement(objectArray[i]);
                ((DefaultListModel)this.runFuncList.getModel()).addElement(objectArray[i]);
            }
        } else if (string == "Remove Function") {
            Object[] objectArray = this.runFuncList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                ((DefaultListModel)this.runFuncList.getModel()).removeElement(objectArray[i]);
                ((DefaultListModel)this.functionList.getModel()).addElement(objectArray[i]);
            }
        } else if (string == "Reset") {
            this.reset();
        } else if (string == "Run") {
            if (this.runFuncList.getModel().getSize() == 0) {
                JOptionPane.showMessageDialog(this, "Please choose at least one statistic");
                return;
            }
            String string2 = this.variableSelector.getSelectedData();
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < this.descrList.getModel().getSize(); ++i) {
                arrayList.add(this.descrList.getModel().getElementAt(i));
            }
            ArrayList arrayList2 = new ArrayList();
            for (int i = 0; i < this.strataList.getModel().getSize(); ++i) {
                arrayList2.add(this.strataList.getModel().getElementAt(i));
            }
            ArrayList<String> arrayList3 = new ArrayList<String>();
            String string3 = "list(";
            for (int i = 0; i < this.runFuncList.getModel().getSize(); ++i) {
                String string4 = (String)this.runFuncList.getModel().getElementAt(i);
                if (string4.indexOf("=") < 0) {
                    arrayList3.add(string4);
                    continue;
                }
                string3 = string3 + string4 + ",";
            }
            string3 = string3 == "list(" ? null : string3.substring(0, string3.length() - 1) + ")";
            this.dispose();
            lastDataName = string2;
            lastDescrModel = (DefaultListModel)this.descrList.getModel();
            lastStrataModel = (DefaultListModel)this.strataList.getModel();
            lastFuncModel = (DefaultListModel)this.runFuncList.getModel();
            JGR.MAINRCONSOLE.toFront();
            JGR.MAINRCONSOLE.execute("descriptive.table(vars = " + Deducer.makeRCollection(arrayList, "d", false) + (arrayList2.size() < 1 ? "" : " ,\n\tstrata = " + Deducer.makeRCollection(arrayList2, "d", false)) + ",data= " + string2 + ",\n\tfunc.names =" + Deducer.makeRCollection(arrayList3, "c", true) + (string3 != null ? ",\n\tfunc.additional= " + string3 + ")" : ")"));
            Deducer.setRecentData(string2);
        } else if (string == "Custom") {
            CustomPopUp customPopUp = new CustomPopUp(this);
            customPopUp.setLocationRelativeTo(null);
            customPopUp.setVisible(true);
        }
    }

    class CustomPopUp
    extends JDialog
    implements ActionListener {
        private JLabel nameLabel;
        private JLabel functionLabel;
        private JScrollPane scroller;
        private JTextPane functionPane;
        private JButton cancel;
        private JButton okay;
        private JTextArea functionText;
        private JTextField name;

        public CustomPopUp(JDialog jDialog) {
            super(jDialog);
            this.initGUI();
        }

        private void initGUI() {
            try {
                AnchorLayout anchorLayout = new AnchorLayout();
                this.getContentPane().setLayout((LayoutManager)anchorLayout);
                this.cancel = new JButton();
                this.getContentPane().add((Component)this.cancel, new AnchorConstraint(883, 726, 959, 509, 1, 1, 1, 1));
                this.cancel.setText("Cancel");
                this.cancel.setPreferredSize(new Dimension(71, 22));
                this.cancel.addActionListener(this);
                this.okay = new JButton();
                this.getContentPane().add((Component)this.okay, new AnchorConstraint(883, 964, 959, 744, 1, 1, 1, 1));
                this.okay.setText("OK");
                this.okay.setPreferredSize(new Dimension(72, 22));
                this.okay.addActionListener(this);
                this.scroller = new JScrollPane();
                this.getContentPane().add((Component)this.scroller, new AnchorConstraint(318, 964, 817, 29, 1, 1, 1, 1));
                this.scroller.setPreferredSize(new Dimension(306, 143));
                this.functionText = new JTextArea();
                this.scroller.setViewportView(this.functionText);
                this.functionLabel = new JLabel();
                this.getContentPane().add((Component)this.functionLabel, new AnchorConstraint(207, 964, 259, 38, 1, 1, 1, 1));
                this.functionLabel.setText("Enter Function - e.g. function(x) sum(x)");
                this.functionLabel.setPreferredSize(new Dimension(303, 15));
                this.functionLabel.setHorizontalAlignment(0);
                this.name = new JTextField();
                this.getContentPane().add((Component)this.name, new AnchorConstraint(54, 964, 130, 368, 1, 1, 1, 1));
                this.name.setPreferredSize(new Dimension(195, 22));
                this.nameLabel = new JLabel();
                this.getContentPane().add((Component)this.nameLabel, new AnchorConstraint(67, 368, 120, 29, 1, 1, 1, 1));
                this.nameLabel.setText("Function Name:");
                this.nameLabel.setPreferredSize(new Dimension(111, 15));
                this.setSize(327, 309);
            }
            catch (Exception exception) {
                new ErrorMsg(exception);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string == "Cancel") {
                this.dispose();
            } else if (string == "OK") {
                if (this.name.getText().length() < 1) {
                    JOptionPane.showMessageDialog(this, "Please Enter a name for the function");
                    return;
                }
                REXP rEXP = new REXP();
                rEXP = Deducer.eval("try(is.function(" + this.functionText.getText() + "),silent=T)");
                if (this.functionText.getText().length() >= 1 && rEXP.isLogical() && !((REXPLogical)rEXP).isTRUE()[0]) {
                    JOptionPane.showMessageDialog(this, "Entered function not valid. Please try again.\n\nHere is an example that calculates the sum\nof a variable:\n                   function(x) sum(x)");
                    return;
                }
                ((DefaultListModel)DescriptivesDialog.this.runFuncList.getModel()).addElement(this.name.getText() + "=" + this.functionText.getText());
                this.dispose();
            }
        }
    }
}

