/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.plots;

import java.util.Vector;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.plots.Aes;
import org.rosuda.deducer.plots.ElementModel;
import org.rosuda.deducer.plots.ElementView;
import org.rosuda.deducer.plots.Geom;
import org.rosuda.deducer.plots.LayerPanel;
import org.rosuda.deducer.plots.Position;
import org.rosuda.deducer.plots.Stat;
import org.rosuda.deducer.widgets.param.Param;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Layer
implements ElementModel {
    private String name;
    public boolean isGeom = false;
    public boolean isStat = false;
    public Geom geom;
    public Stat stat;
    public Position pos;
    public Vector aess;
    public String data;

    public void setStat(Stat stat) {
        this.stat = stat;
        if (this.geom != null) {
            this.generateAes();
        }
    }

    public Stat getStat() {
        return this.stat;
    }

    public void setGeom(Geom geom) {
        this.geom = geom;
        if (this.stat != null) {
            this.generateAes();
        }
    }

    public Geom getGeom() {
        return this.geom;
    }

    public Object clone() {
        Layer layer = new Layer();
        layer.isGeom = this.isGeom;
        layer.isStat = this.isStat;
        layer.data = this.data;
        layer.geom = (Geom)this.geom.clone();
        layer.stat = (Stat)this.stat.clone();
        layer.pos = (Position)this.pos.clone();
        layer.generateAes();
        return layer;
    }

    public String getCall() {
        int n;
        int n2;
        Object object;
        Object object2;
        Vector<Object> vector = new Vector<Object>();
        Vector<Object> vector2 = new Vector<Object>();
        for (int i = 0; i < this.aess.size(); ++i) {
            Aes aes = (Aes)this.aess.get(i);
            object2 = aes.getAesCalls();
            for (int j = 0; j < ((String[])object2).length; ++j) {
                vector.add(object2[j]);
            }
            object = aes.getParamCalls();
            for (n2 = 0; n2 < ((String[])object).length; ++n2) {
                vector2.add(object[n2]);
            }
        }
        Vector vector3 = this.stat.params;
        for (n = 0; n < vector3.size(); ++n) {
            object2 = (Param)vector3.get(n);
            object = ((Param)object2).getParamCalls();
            for (n2 = 0; n2 < ((String[])object).length; ++n2) {
                vector2.add(object[n2]);
            }
        }
        vector3 = this.geom.params;
        for (n = 0; n < vector3.size(); ++n) {
            object2 = (Param)vector3.get(n);
            object = ((Param)object2).getParamCalls();
            for (n2 = 0; n2 < ((String[])object).length; ++n2) {
                vector2.add(object[n2]);
            }
        }
        String string = Deducer.makeRCollection(vector, "aes", false);
        Object object3 = object2 = this.data == null ? null : "data=" + this.data;
        if (object2 != null) {
            vector2.add(0, object2);
        }
        if (vector.size() > 0) {
            vector2.add(0, string);
        }
        object = "";
        if (this.isGeom) {
            object = "geom_" + this.geom.name;
            if (!this.geom.defaultStat.equals(this.stat.name)) {
                vector2.add("stat = '" + this.stat.name + "'");
            }
        } else if (this.isStat) {
            object = "stat_" + this.stat.name;
            if (!this.stat.defaultGeom.equals(this.geom.name)) {
                vector2.add("geom = '" + this.geom.name + "'");
            }
        }
        if (!this.pos.name.equals(this.geom.defaultPosition) || this.pos.height != null || this.pos.width != null) {
            String string2 = "position = position_" + this.pos.name + "(" + (this.pos.height == null ? "" : "height = " + this.pos.height.toString()) + (this.pos.height != null && this.pos.width != null ? "," : "") + (this.pos.width == null ? "" : "width = " + this.pos.width.toString()) + ")";
            vector2.add(string2);
        }
        return Deducer.makeRCollection(vector2, (String)object, false);
    }

    public String checkValid() {
        for (int i = 0; i < this.aess.size(); ++i) {
            Aes aes = (Aes)this.aess.get(i);
            if (!aes.required || aes.value != null || aes.variable != null) continue;
            return "Required variable " + aes.name + " not specified";
        }
        return null;
    }

    public String getType() {
        return "layer";
    }

    public ElementView getView() {
        LayerPanel layerPanel = new LayerPanel(this);
        return layerPanel;
    }

    public void generateAes() {
        boolean bl;
        Aes aes;
        int n;
        Vector vector = this.stat.aess;
        Vector vector2 = this.geom.aess;
        this.aess = new Vector();
        int n2 = 0;
        for (n = 0; n < vector2.size(); ++n) {
            Aes aes2 = new Aes();
            aes = (Aes)vector2.get(n);
            if (this.stat.generated.contains(aes.name)) continue;
            bl = false;
            for (int i = 0; i < vector.size(); ++i) {
                aes2 = (Aes)vector.get(i);
                if (!aes.name.equals(aes2.name)) continue;
                bl = true;
                break;
            }
            if (!bl || aes2.variable == null) {
                if (aes.required) {
                    this.aess.add(n2++, aes);
                    continue;
                }
                this.aess.add(aes);
                continue;
            }
            if (aes2.required) {
                this.aess.add(n2++, aes2);
                continue;
            }
            this.aess.add(aes2);
        }
        n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            aes = (Aes)vector.get(i);
            bl = false;
            for (int j = 0; j < this.aess.size(); ++j) {
                Aes aes3 = (Aes)this.aess.get(j);
                if (!aes.name.equals(aes3.name)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            if (aes.required) {
                this.aess.add(n++, aes);
                continue;
            }
            this.aess.add(aes);
        }
    }

    public static Layer makeGeomLayer(String string) {
        Geom geom = Geom.makeGeom(string);
        if (geom == null || geom.defaultStat == null || geom.defaultPosition == null) {
            return null;
        }
        Stat stat = Stat.makeStat(geom.defaultStat);
        if (stat == null) {
            JOptionPane.showMessageDialog(null, geom.defaultStat + " is not a valid stat" + "when making geom " + string);
        }
        Position position = Position.makePosition(geom.defaultPosition);
        Layer layer = new Layer();
        layer.setName("geom_" + string);
        layer.isGeom = true;
        layer.geom = geom;
        layer.stat = stat;
        layer.pos = position;
        layer.generateAes();
        return layer;
    }

    public static Layer makeStatLayer(String string) {
        Stat stat = Stat.makeStat(string);
        if (stat == null || stat.defaultGeom == null) {
            return null;
        }
        Geom geom = Geom.makeGeom(stat.defaultGeom);
        if (geom == null || stat == null || geom.defaultPosition == null) {
            JOptionPane.showMessageDialog(null, string + " is not a valid geom.");
        }
        Position position = Position.makePosition(geom.defaultPosition);
        Layer layer = new Layer();
        layer.setName("stat_" + string);
        layer.isStat = true;
        layer.geom = geom;
        layer.stat = stat;
        layer.pos = position;
        layer.generateAes();
        return layer;
    }

    public Vector getParams() {
        int n;
        Vector vector = new Vector();
        for (n = 0; n < this.stat.params.size(); ++n) {
            vector.add(this.stat.params.get(n));
        }
        for (n = 0; n < this.geom.params.size(); ++n) {
            vector.add(this.geom.params.get(n));
        }
        return vector;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public String getData() {
        return this.data;
    }

    public Element toXML() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("ElementModel");
            if (this.name != null) {
                element.setAttribute("name", this.name);
            }
            if (this.data != null) {
                element.setAttribute("data", this.data);
            }
            element.setAttribute("isGeom", this.isGeom ? "true" : "false");
            element.setAttribute("isStat", this.isStat ? "true" : "false");
            Element element2 = this.stat.toXML();
            element2 = (Element)document.importNode(element2, true);
            element.appendChild(element2);
            element2 = this.geom.toXML();
            element2 = (Element)document.importNode(element2, true);
            element.appendChild(element2);
            element2 = this.pos.toXML();
            element2 = (Element)document.importNode(element2, true);
            element.appendChild(element2);
            element.setAttribute("className", "org.rosuda.deducer.plots.Layer");
            document.appendChild(element);
            return element;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void setFromXML(Element element) {
        String string = element.getAttribute("className");
        if (!string.equals("org.rosuda.deducer.plots.Layer")) {
            System.out.println("Error Layer: class mismatch: " + string);
            new Exception().printStackTrace();
        }
        this.name = element.hasAttribute("name") ? element.getAttribute("name") : null;
        this.data = element.hasAttribute("data") ? element.getAttribute("data") : null;
        this.isGeom = element.getAttribute("isGeom").equals("true");
        this.isStat = element.getAttribute("isStat").equals("true");
        Element element2 = (Element)element.getElementsByTagName("Geom").item(0);
        this.geom = new Geom();
        this.geom.setFromXML(element2);
        element2 = (Element)element.getElementsByTagName("Stat").item(0);
        this.stat = new Stat();
        this.stat.setFromXML(element2);
        element2 = (Element)element.getElementsByTagName("Position").item(0);
        this.pos = new Position();
        this.pos.setFromXML(element2);
        this.generateAes();
    }
}

