% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/declare_test.R
\name{declare_test}
\alias{declare_test}
\alias{label_test}
\title{Declare test}
\usage{
declare_test(..., handler = label_test(model_handler), label = "test")

label_test(fn)
}
\arguments{
\item{...}{arguments to be captured, and later passed to the handler}

\item{handler}{a tidy-in, tidy-out function}

\item{label}{a string describing the step}

\item{fn}{A function that takes a data.frame as an argument and returns a data.frame with test statistics as columns.}
}
\value{
A function that accepts a data.frame as an argument and returns a data.frame containing the value of the test statistic and other inferential statistics.
}
\description{
Declares an test which generates a test statistic and associated inferential statistics. 

Use of \code{declare_test} is identical to use of \code{\link{declare_estimator}}. Use \code{declare_test} for hypothesis testing with no specific inquiry in mind; use \code{declare_estimator} for hypothesis testing when you can link each estimate to an inquiry. For example, \code{declare_test} could be used for a K-S test of distributional equality and \code{declare_estimator} for a difference-in-means estimate of an average treatment effect.

See \code{\link{declare_estimator}} help for an explanation of how to use \code{model_handler}, which is used identically in both \code{declare_estimator} and \code{declare_test}. The main difference between \code{declare_estimator} and \code{declare_test} is that \code{declare_test} does not link with an explicit inquiry.
}
\details{
\code{label_test} takes a data-in-data out function to \code{fn}, and returns a data-in-data-out function that first runs the provided test function \code{fn} and then appends a label for the test.
}
\examples{

# Balance test F test

balance_test_design <-
  declare_model(
    N = 100, 
    cov1 = rnorm(N), 
    cov2 = rnorm(N), 
    cov3 = rnorm(N)
  ) +
  declare_assignment(Z = complete_ra(N, prob = 0.2), legacy = FALSE) +
  declare_test(Z ~ cov1 + cov2 + cov3, model = lm_robust, model_summary = glance)
  
\dontrun{
diagnosis <- diagnose_design(
  design = balance_test_design,
  diagnosands = declare_diagnosands(
  false_positive_rate = mean(p.value <= 0.05))
)
}

# K-S test of distributional equality

ks_test <- function(data) {
  test <- with(data, ks.test(x = Y[Z == 1], y = Y[Z == 0]))
  data.frame(statistic = test$statistic, p.value = test$p.value)
}

distributional_equality_design <-
  declare_model(
    N = 100, 
    Y_Z_1 = rnorm(N), 
    Y_Z_0 = rnorm(N, sd = 1.5)
  ) + 
  declare_assignment(Z = complete_ra(N, prob = 0.5), legacy = FALSE) + 
  declare_measurement(Y = reveal_outcomes(Y ~ Z)) + 
  declare_test(handler = label_test(ks_test), label = "ks-test")
  
\dontrun{
diagnosis <- diagnose_design(
  design = distributional_equality_design,
  diagnosands = declare_diagnosands(power = mean(p.value <= 0.05))
) 
}

# Thanks to Jake Bowers for this example

library(coin) 

our_ttest <- function(data) {
  res <- coin::oneway_test(
    outcome ~ factor(Xclus),
    data = data,
    distribution = "asymptotic"
  )
  data.frame(p.value = pvalue(res)[[1]])
}

ttest_design <- 
  declare_model(
    N = 100, 
    Xclus = rbinom(n = N, size = 1, prob = 0.2), 
    outcome = 3 + rnorm(N)) +
  declare_test(handler = label_test(our_ttest), label = "t-test")
  
\dontrun{
diagnosis <- diagnose_design(
  design = ttest_design,
  diagnosands = declare_diagnosands(
    false_positive_rate = mean(p.value <= 0.05))
)
}

}
\seealso{
See \code{\link{declare_estimator}} for documentation of the \code{model_handler} function.
}
