% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnosis_helper_functions.R
\name{diagnosis_helpers}
\alias{diagnosis_helpers}
\alias{get_diagnosands}
\alias{get_simulations}
\title{Explore your design diagnosis}
\usage{
get_diagnosands(diagnosis)

get_simulations(diagnosis)
}
\arguments{
\item{diagnosis}{A design diagnosis created by \code{\link{diagnose_design}}.}
}
\description{
Explore your design diagnosis
}
\examples{
design <- 
  declare_model(
    N = 500, 
    U = rnorm(N),
    Y_Z_0 = U, 
    Y_Z_1 = U + rnorm(N, mean = 2, sd = 2)
  ) + 
  declare_assignment(Z = complete_ra(N), legacy = FALSE) + 
  declare_inquiry(ATE = mean(Y_Z_1 - Y_Z_0)) + 
  declare_measurement(Y = reveal_outcomes(Y ~ Z)) +
  declare_estimator(Y ~ Z, inquiry = "ATE") 

\dontrun{
# using built-in defaults:
diagnosis <- diagnose_design(design)
diagnosis
}

# using a user-defined diagnosand
my_diagnosand <- declare_diagnosands(
  absolute_error = mean(abs(estimate - estimand)))

\dontrun{
diagnosis <- diagnose_design(design, diagnosands = my_diagnosand)
diagnosis

get_diagnosands(diagnosis)

get_simulations(diagnosis)

reshape_diagnosis(diagnosis)

}

}
