/*
 * Decompiled with CFR 0.152.
 */
package net.starschema.clouddb.jdbc;

import com.google.api.services.bigquery.model.Job;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import net.starschema.clouddb.jdbc.BQConnection;
import net.starschema.clouddb.jdbc.BQForwardOnlyResultSet;
import net.starschema.clouddb.jdbc.BQQueryParser;
import net.starschema.clouddb.jdbc.BQSQLException;
import net.starschema.clouddb.jdbc.BQSQLFeatureNotSupportedException;
import net.starschema.clouddb.jdbc.BQScrollableResultSet;
import net.starschema.clouddb.jdbc.BQStatementRoot;
import net.starschema.clouddb.jdbc.BQSupportFuncts;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.io.IOUtils;

public class BQPreparedStatement
extends BQStatementRoot
implements PreparedStatement {
    String PrecompiledSQL = null;
    String RunnableStatement = null;
    String[] Parameters = null;

    public BQPreparedStatement(String querysql, String projectid, BQConnection bqConnection) {
        this.logger.debug("Constructor of PreparedStatement Running projectid is:" + projectid + "sqlquery: " + querysql);
        this.ProjectId = projectid;
        this.connection = bqConnection;
        this.resultSetType = 1003;
        this.resultSetConcurrency = 1007;
        this.PrecompiledSQL = querysql;
        if (!this.PrecompiledSQL.contains("?")) {
            this.RunnableStatement = this.PrecompiledSQL;
        }
        int count = 0;
        for (int i = 0; i < querysql.length(); ++i) {
            if (querysql.charAt(i) != '?') continue;
            ++count;
        }
        if (count != 0) {
            this.Parameters = new String[count];
        }
        this.logger.debug("Constructor of PreparedStatement Ended with " + projectid);
    }

    public BQPreparedStatement(String querysql, String projectid, BQConnection bqConnection, int resultSetType, int resultSetConcurrency) throws BQSQLException {
        if (resultSetConcurrency == 1008) {
            this.logger.debug("BQPreparedStatement constructor error");
            throw new BQSQLException("The Resultset Concurrency can't be ResultSet.CONCUR_UPDATABLE");
        }
        this.ProjectId = projectid;
        this.connection = bqConnection;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.PrecompiledSQL = querysql;
        int count = 0;
        for (int i = 0; i < querysql.length(); ++i) {
            if (querysql.charAt(i) != '?') continue;
            ++count;
        }
        if (count != 0) {
            this.Parameters = new String[count];
        }
    }

    @Override
    public void addBatch() throws SQLException {
        this.logger.debug("BQPreparedStatement::addBatch not implemented");
        throw new BQSQLException("Not implemented.addBatch()");
    }

    @Override
    public void clearParameters() throws SQLException {
        int count = 0;
        for (int i = 0; i < this.PrecompiledSQL.length(); ++i) {
            if (this.PrecompiledSQL.charAt(i) != '?') continue;
            ++count;
        }
        this.Parameters = count != 0 ? new String[count] : null;
        this.RunnableStatement = this.PrecompiledSQL;
    }

    private void constructsql() {
        String[] data = this.PrecompiledSQL.split("\\?");
        String newsql = data[0];
        int countofsema = 0;
        for (int i = 0; i < this.Parameters.length; ++i) {
            if (this.Parameters[i] == null) {
                if (++countofsema < data.length) {
                    newsql = newsql + "?" + data[countofsema];
                    continue;
                }
                newsql = newsql + "?";
                continue;
            }
            newsql = ++countofsema < data.length ? newsql + this.Parameters[i] + data[countofsema] : newsql + this.Parameters[i];
        }
        this.RunnableStatement = newsql;
    }

    @Override
    public boolean execute() throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("This Statement is Closed");
        }
        String normalizedUpdateSql = this.normalizeDataDefinitionForParsing(this.RunnableStatement);
        Tree dataDefinitionTree = this.tryParseDataDefinition(normalizedUpdateSql);
        if (dataDefinitionTree != null || this.isSupportedDML(normalizedUpdateSql)) {
            this.updateCount = this.executeUpdate(this.RunnableStatement);
            return false;
        }
        this.resset = this.executeQuery();
        this.logger.info("Executing Query: " + this.RunnableStatement);
        return this.resset != null;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        Job referencedJob;
        if (this.isClosed()) {
            throw new BQSQLException("This Statement is Closed");
        }
        if (this.RunnableStatement == null) {
            throw new BQSQLException("Parameters are not set");
        }
        if (this.RunnableStatement.contains("?")) {
            throw new BQSQLException("Not all parameters set");
        }
        this.starttime = System.currentTimeMillis();
        if (this.isNextvalQuery(this.RunnableStatement)) {
            return this.executeNextvalQuery(this.RunnableStatement);
        }
        BQQueryParser parser = new BQQueryParser(this.RunnableStatement, this.connection);
        this.RunnableStatement = parser.parse();
        try {
            referencedJob = BQSupportFuncts.startQuery(this.connection.getBigquery(), this.ProjectId.replace("__", ":").replace("_", "."), this.RunnableStatement, this.connection.getDataSet(), this.connection.getUseLegacySql(), this.connection.getMaxBillingBytes());
            this.logger.info("BQPreparedStatement::executeQuery: " + this.RunnableStatement);
        }
        catch (IOException e) {
            throw new BQSQLException("Something went wrong with the query: " + this.RunnableStatement, e);
        }
        try {
            do {
                if (BQSupportFuncts.getQueryState(referencedJob, this.connection.getBigquery(), this.ProjectId.replace("__", ":").replace("_", ".")).equals("DONE")) {
                    if (this.resultSetType == 1004) {
                        return new BQScrollableResultSet(BQSupportFuncts.getQueryResults(this.connection.getBigquery(), this.ProjectId.replace("__", ":").replace("_", "."), referencedJob), this);
                    }
                    return new BQForwardOnlyResultSet(this.connection.getBigquery(), this.ProjectId.replace("__", ":").replace("_", "."), referencedJob, this);
                }
                Thread.sleep(500L);
                this.logger.debug("slept for 500ms, querytimeout is: " + this.querytimeout + "s");
            } while (System.currentTimeMillis() - this.starttime <= (long)this.querytimeout * 1000L);
        }
        catch (IOException e) {
            throw new BQSQLException("Something went wrong with the query: " + this.RunnableStatement, e);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        throw new BQSQLException("Query run took more than the specified timeout");
    }

    @Override
    public int executeUpdate() throws SQLException {
        Job referencedJob;
        if (this.isClosed()) {
            throw new BQSQLException("This Statement is Closed");
        }
        if (this.RunnableStatement == null) {
            throw new BQSQLException("Parameters are not set");
        }
        if (this.RunnableStatement.contains("?")) {
            throw new BQSQLException("Not all parameters set");
        }
        this.starttime = System.currentTimeMillis();
        String normalizedUpdateSql = this.normalizeDataDefinitionForParsing(this.RunnableStatement);
        Tree dataDefinitionTree = this.tryParseDataDefinition(normalizedUpdateSql);
        if (dataDefinitionTree != null) {
            return this.executeDataDefinition(dataDefinitionTree, normalizedUpdateSql);
        }
        try {
            referencedJob = BQSupportFuncts.startQuery(this.connection.getBigquery(), this.ProjectId.replace("__", ":").replace("_", "."), this.RunnableStatement, this.connection.getDataSet(), false, this.connection.getMaxBillingBytes());
            this.logger.info("BQPreparedStatement::executeUpdate: " + this.RunnableStatement);
        }
        catch (IOException e) {
            throw new BQSQLException("Something went wrong with the update: " + this.RunnableStatement, e);
        }
        Job pollJob = null;
        try {
            do {
                if ((pollJob = BQSupportFuncts.getQueryJob(referencedJob, this.connection.getBigquery(), this.ProjectId.replace("__", ":").replace("_", "."))).getStatus().getState().equals("DONE")) {
                    if (pollJob.getStatus().getErrors() == null) {
                        return pollJob.getStatistics().getQuery().getNumDmlAffectedRows().intValue();
                    }
                    throw new BQSQLException("Error during update: " + pollJob.getStatus().getErrors().toString());
                }
                Thread.sleep(500L);
                this.logger.debug("slept for 500ms, querytimeout is: " + this.querytimeout + "s");
            } while (System.currentTimeMillis() - this.starttime <= (long)this.querytimeout * 1000L);
        }
        catch (IOException e) {
            throw new BQSQLException("Something went wrong with the update: " + this.RunnableStatement, e);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (pollJob != null) {
            try {
                BQSupportFuncts.cancelQuery(pollJob, this.connection.getBigquery(), this.ProjectId);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        throw new BQSQLException("Update run took more than the specified timeout");
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.logger.debug("function call: getParameterMetaData()");
        return null;
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.logger.debug("BQPreparedStatement::setArray not implemented");
        throw new BQSQLException(new SQLFeatureNotSupportedException());
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("The Statement is Closed");
        }
        if (this.Parameters == null) {
            throw new BQSQLException("Index is not valid");
        }
        if (parameterIndex < 1 || parameterIndex > this.Parameters.length) {
            throw new BQSQLException("Index is not valid");
        }
        StringWriter writer = new StringWriter();
        try {
            IOUtils.copy(x, writer, "UTF-8");
        }
        catch (IOException e) {
            throw new BQSQLException(e);
        }
        String theString = writer.toString();
        this.SetParameter(parameterIndex, "\"" + theString + "\"");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("The Statement is Closed");
        }
        if (this.Parameters == null) {
            throw new BQSQLException("Index is not valid");
        }
        if (parameterIndex < 1 || parameterIndex > this.Parameters.length) {
            throw new BQSQLException("Index is not valid");
        }
        StringWriter writer = new StringWriter();
        try {
            IOUtils.copy(x, writer, "UTF-8");
        }
        catch (IOException e) {
            throw new BQSQLException(e);
        }
        String theString = writer.toString();
        this.SetParameter(parameterIndex, "\"" + theString + "\"");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("The Statement is Closed");
        }
        if (this.Parameters == null) {
            throw new BQSQLException("Index is not valid");
        }
        if (parameterIndex < 1 || parameterIndex > this.Parameters.length) {
            throw new BQSQLException("Index is not valid");
        }
        StringWriter writer = new StringWriter();
        try {
            IOUtils.copy(x, writer, "UTF-8");
        }
        catch (IOException e) {
            throw new BQSQLException(e);
        }
        String theString = writer.toString();
        this.SetParameter(parameterIndex, "\"" + theString + "\"");
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("The Statement is Closed");
        }
        if (this.Parameters == null) {
            throw new BQSQLException("Index is not valid");
        }
        if (parameterIndex < 1 || parameterIndex > this.Parameters.length) {
            throw new BQSQLException("Index is not valid");
        }
        this.SetParameter(parameterIndex, x.toString());
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.logger.debug("BQPreparedStatement::setBinaryStream not implemented");
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.logger.debug("BQPreparedStatement::setBinaryStream not implemented");
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.logger.debug("BQPreparedStatement::setBinaryStream not implemented");
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.logger.debug("BQPreparedStatement::setBlob not implemented");
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.logger.debug("BQPreparedStatement::setBlob not implemented");
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.logger.debug("BQPreparedStatement::setBlob not implemented");
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("The Statement is Closed");
        }
        if (this.Parameters == null) {
            throw new BQSQLException("Index is not valid");
        }
        if (parameterIndex < 1 || parameterIndex > this.Parameters.length) {
            throw new BQSQLException("Index is not valid");
        }
        this.SetParameter(parameterIndex, Boolean.toString(x));
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("The Statement is Closed");
        }
        if (this.Parameters == null) {
            throw new BQSQLException("Index is not valid");
        }
        if (parameterIndex < 1 || parameterIndex > this.Parameters.length) {
            throw new BQSQLException("Index is not valid");
        }
        this.SetParameter(parameterIndex, Integer.toString(x & 0xFF));
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.logger.debug("BQPreparedStatement::setBytes not implemented");
        throw new BQSQLException(new SQLFeatureNotSupportedException());
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("The Statement is Closed");
        }
        if (this.Parameters == null) {
            throw new BQSQLException("Index is not valid");
        }
        if (parameterIndex < 1 || parameterIndex > this.Parameters.length) {
            throw new BQSQLException("Index is not valid");
        }
        char[] arr = new char[8192];
        StringBuffer buf = new StringBuffer();
        try {
            int numChars;
            while ((numChars = reader.read(arr, 0, arr.length)) > 0) {
                buf.append(arr, 0, numChars);
            }
        }
        catch (IOException e) {
            throw new BQSQLException(e);
        }
        this.SetParameter(parameterIndex, "\"" + buf.toString() + "\"");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.logger.debug("BQPreparedStatement::setClob not implemented");
        throw new BQSQLException(new SQLFeatureNotSupportedException());
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.logger.debug("BQPreparedStatement::setClob not implemented");
        throw new BQSQLException(new SQLFeatureNotSupportedException());
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.logger.debug("BQPreparedStatement::setClob not implemented");
        throw new BQSQLException(new SQLFeatureNotSupportedException());
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("The Statement is Closed");
        }
        if (this.Parameters == null) {
            throw new BQSQLException("Index is not valid");
        }
        if (parameterIndex < 1 || parameterIndex > this.Parameters.length) {
            throw new BQSQLException("Index is not valid");
        }
        Date s = new Date(x.getTime() + (long)Calendar.getInstance().getTimeZone().getRawOffset());
        this.SetParameter(parameterIndex, "\"" + s.toString() + "\"");
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("The Statement is Closed");
        }
        if (this.Parameters == null) {
            throw new BQSQLException("Index is not valid");
        }
        if (parameterIndex < 1 || parameterIndex > this.Parameters.length) {
            throw new BQSQLException("Index is not valid");
        }
        Date s = new Date(x.getTime() + (long)(cal == null ? Calendar.getInstance().getTimeZone().getRawOffset() : cal.getTimeZone().getRawOffset()));
        this.SetParameter(parameterIndex, "\"" + s.toString() + "\"");
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("The Statement is Closed");
        }
        if (this.Parameters == null) {
            throw new BQSQLException("Index is not valid");
        }
        if (parameterIndex < 1 || parameterIndex > this.Parameters.length) {
            throw new BQSQLException("Index is not valid");
        }
        this.SetParameter(parameterIndex, Double.toString(x));
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("The Statement is Closed");
        }
        if (this.Parameters == null) {
            throw new BQSQLException("Index is not valid");
        }
        if (parameterIndex < 1 || parameterIndex > this.Parameters.length) {
            throw new BQSQLException("Index is not valid");
        }
        this.SetParameter(parameterIndex, Float.toString(x));
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("The Statement is Closed");
        }
        if (this.Parameters == null) {
            throw new BQSQLException("Index is not valid");
        }
        if (parameterIndex < 1 || parameterIndex > this.Parameters.length) {
            throw new BQSQLException("Index is not valid");
        }
        this.SetParameter(parameterIndex, Integer.toString(x));
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("The Statement is Closed");
        }
        if (this.Parameters == null) {
            throw new BQSQLException("Index is not valid");
        }
        if (parameterIndex < 1 || parameterIndex > this.Parameters.length) {
            throw new BQSQLException("Index is not valid");
        }
        this.SetParameter(parameterIndex, Long.toString(x));
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.logger.debug("BQPreparedStatement::setNClob not implemented");
        throw new BQSQLException(new SQLFeatureNotSupportedException());
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.logger.debug("BQPreparedStatement::setNClob not implemented");
        throw new BQSQLException(new SQLFeatureNotSupportedException());
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.logger.debug("BQPreparedStatement::setNClob not implemented");
        throw new BQSQLException(new SQLFeatureNotSupportedException());
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.setString(parameterIndex, value);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("The Statement is Closed");
        }
        if (this.Parameters == null) {
            throw new BQSQLException("Index is not valid");
        }
        if (parameterIndex < 1 || parameterIndex > this.Parameters.length) {
            throw new BQSQLException("Index is not valid");
        }
        this.SetParameter(parameterIndex, "NULL");
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("The Statement is Closed");
        }
        if (this.Parameters == null) {
            throw new BQSQLException("Index is not valid");
        }
        if (parameterIndex < 1 || parameterIndex > this.Parameters.length) {
            throw new BQSQLException("Index is not valid");
        }
        this.SetParameter(parameterIndex, "NULL");
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("The Statement is Closed");
        }
        if (this.Parameters == null) {
            throw new BQSQLException("Index is not valid");
        }
        if (parameterIndex < 1 || parameterIndex > this.Parameters.length) {
            throw new BQSQLException("Index is not valid");
        }
        if (x.getClass().equals(Integer.class)) {
            this.setInt(parameterIndex, (Integer)Integer.class.cast(x));
        } else if (x.getClass().equals(String.class)) {
            this.setString(parameterIndex, (String)String.class.cast(x));
        } else if (x.getClass().equals(Reader.class)) {
            this.setCharacterStream(parameterIndex, (Reader)Reader.class.cast(x));
        } else if (x.getClass().equals(Long.class)) {
            this.setLong(parameterIndex, (Long)Long.class.cast(x));
        } else if (x.getClass().equals(Float.class)) {
            this.setFloat(parameterIndex, ((Float)Float.class.cast(x)).floatValue());
        } else if (x.getClass().equals(Double.class)) {
            this.setDouble(parameterIndex, (Double)Double.class.cast(x));
        } else if (x.getClass().equals(Date.class)) {
            this.setDate(parameterIndex, (Date)Date.class.cast(x));
        } else if (x.getClass().equals(Time.class)) {
            this.setTime(parameterIndex, (Time)Time.class.cast(x));
        } else if (x.getClass().equals(Timestamp.class)) {
            this.setTimestamp(parameterIndex, (Timestamp)Timestamp.class.cast(x));
        } else if (x.getClass().equals(Byte.class)) {
            this.setByte(parameterIndex, (Byte)Byte.class.cast(x));
        } else if (x.getClass().equals(BigDecimal.class)) {
            this.setBigDecimal(parameterIndex, (BigDecimal)BigDecimal.class.cast(x));
        } else if (x.getClass().equals(RowId.class)) {
            this.setRowId(parameterIndex, (RowId)RowId.class.cast(x));
        } else if (x.getClass().equals(Short.class)) {
            this.setShort(parameterIndex, (Short)Short.class.cast(x));
        } else if (x.getClass().equals(SQLXML.class)) {
            this.setSQLXML(parameterIndex, (SQLXML)SQLXML.class.cast(x));
        } else if (x.getClass().equals(URL.class)) {
            this.setURL(parameterIndex, (URL)URL.class.cast(x));
        } else if (x.getClass().equals(Boolean.class)) {
            this.setBoolean(parameterIndex, (Boolean)Boolean.class.cast(x));
        } else if (x.getClass().equals(InputStream.class)) {
            this.setAsciiStream(parameterIndex, (InputStream)InputStream.class.cast(x));
        } else {
            throw new BQSQLException(new SQLFeatureNotSupportedException());
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.logger.debug("BQPreparedStatement::setObject ignoring targetSqlType " + targetSqlType);
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.logger.debug("BQPreparedStatement::setObject ignoring scalreOrLength and targetSqlType " + targetSqlType);
        this.setObject(parameterIndex, x);
    }

    private void SetParameter(int paramterNumber, String value) {
        this.Parameters[paramterNumber - 1] = value;
        this.constructsql();
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.logger.debug("BQPreparedStatement::setRef not implemented");
        throw new BQSQLException(new SQLFeatureNotSupportedException());
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("The Statement is Closed");
        }
        if (this.Parameters == null) {
            throw new BQSQLException("Index is not valid");
        }
        if (parameterIndex < 1 || parameterIndex > this.Parameters.length) {
            throw new BQSQLException("Index is not valid");
        }
        this.SetParameter(parameterIndex, "\"" + x.toString() + "\"");
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        int myint = new Integer(x);
        this.setInt(parameterIndex, myint);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("The Statement is Closed");
        }
        if (this.Parameters == null) {
            throw new BQSQLException("Index is not valid");
        }
        if (parameterIndex < 1 || parameterIndex > this.Parameters.length) {
            throw new BQSQLException("Index is not valid");
        }
        this.SetParameter(parameterIndex, "\"" + xmlObject.getString() + "\"");
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("The Statement is Closed");
        }
        if (this.Parameters == null) {
            throw new BQSQLException("Index is not valid");
        }
        if (parameterIndex < 1 || parameterIndex > this.Parameters.length) {
            throw new BQSQLException("Index is not valid");
        }
        this.SetParameter(parameterIndex, "\"" + this.quoteSqlString(x) + "\"");
    }

    private String quoteSqlString(String s) {
        return s.replace("\"", "\\\"");
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("The Statement is Closed");
        }
        if (this.Parameters == null) {
            throw new BQSQLException("Index is not valid");
        }
        if (parameterIndex < 1 || parameterIndex > this.Parameters.length) {
            throw new BQSQLException("Index is not valid");
        }
        Time s = new Time(x.getTime() + (long)Calendar.getInstance().getTimeZone().getRawOffset());
        this.SetParameter(parameterIndex, "\"" + s.toString() + "\"");
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("The Statement is Closed");
        }
        if (this.Parameters == null) {
            throw new BQSQLException("Index is not valid");
        }
        if (parameterIndex < 1 || parameterIndex > this.Parameters.length) {
            throw new BQSQLException("Index is not valid");
        }
        Time s = new Time(x.getTime() + (long)(cal == null ? Calendar.getInstance().getTimeZone().getRawOffset() : cal.getTimeZone().getRawOffset()));
        this.SetParameter(parameterIndex, "\"" + s.toString() + "\"");
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("The Statement is Closed");
        }
        if (this.Parameters == null) {
            throw new BQSQLException("Index is not valid");
        }
        if (parameterIndex < 1 || parameterIndex > this.Parameters.length) {
            throw new BQSQLException("Index is not valid");
        }
        Timestamp s = new Timestamp(x.getTime() + (long)Calendar.getInstance().getTimeZone().getRawOffset());
        this.SetParameter(parameterIndex, "\"" + s.toString() + "\"");
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("The Statement is Closed");
        }
        if (this.Parameters == null) {
            throw new BQSQLException("Index is not valid");
        }
        if (parameterIndex < 1 || parameterIndex > this.Parameters.length) {
            throw new BQSQLException("Index is not valid");
        }
        Timestamp s = new Timestamp(x.getTime() + (long)(cal == null ? Calendar.getInstance().getTimeZone().getRawOffset() : cal.getTimeZone().getRawOffset()));
        this.SetParameter(parameterIndex, "\"" + s.toString() + "\"");
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("The Statement is Closed");
        }
        if (this.Parameters == null) {
            throw new BQSQLException("Index is not valid");
        }
        if (parameterIndex < 1 || parameterIndex > this.Parameters.length) {
            throw new BQSQLException("Index is not valid");
        }
        StringWriter writer = new StringWriter();
        try {
            IOUtils.copy(x, writer, "UTF-8");
        }
        catch (IOException e) {
            throw new BQSQLException(e);
        }
        String theString = writer.toString();
        this.SetParameter(parameterIndex, "\"" + theString + "\"");
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("The Statement is Closed");
        }
        if (this.Parameters == null) {
            throw new BQSQLException("Index is not valid");
        }
        if (parameterIndex < 1 || parameterIndex > this.Parameters.length) {
            throw new BQSQLException("Index is not valid");
        }
        this.SetParameter(parameterIndex, "\"" + x.toString() + "\"");
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.logger.debug("BQPreparedStatement::closeOnCompletion");
        throw new BQSQLException("Not implemented.");
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.logger.debug("BQPreparedStatement::isCloseOnCompletion");
        throw new BQSQLException("Not implemented.");
    }
}

