% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sql.R
\name{renderTranslateQuerySql}
\alias{renderTranslateQuerySql}
\title{Render, translate, and query to data.frame}
\usage{
renderTranslateQuerySql(
  connection,
  sql,
  errorReportFile = file.path(getwd(), "errorReportSql.txt"),
  snakeCaseToCamelCase = FALSE,
  oracleTempSchema = NULL,
  tempEmulationSchema = getOption("sqlRenderTempEmulationSchema"),
  integerAsNumeric = getOption("databaseConnectorIntegerAsNumeric", default = TRUE),
  integer64AsNumeric = getOption("databaseConnectorInteger64AsNumeric", default = TRUE),
  ...
)
}
\arguments{
\item{connection}{The connection to the database server created using either
\code{\link[=connect]{connect()}} or \code{\link[DBI:dbConnect]{DBI::dbConnect()}}.}

\item{sql}{The SQL to be send.}

\item{errorReportFile}{The file where an error report will be written if an error occurs.
Defaults to 'errorReportSql.txt' in the current working directory.}

\item{snakeCaseToCamelCase}{If true, field names are assumed to use snake_case, and are converted to camelCase.}

\item{oracleTempSchema}{DEPRECATED: use \code{tempEmulationSchema} instead.}

\item{tempEmulationSchema}{Some database platforms like Oracle and Impala do not truly support temp tables. To
emulate temp tables, provide a schema with write privileges where temp tables
can be created.}

\item{integerAsNumeric}{Logical: should 32-bit integers be converted to numeric (double) values? If FALSE
32-bit integers will be represented using R's native \code{Integer} class.}

\item{integer64AsNumeric}{Logical: should 64-bit integers be converted to numeric (double) values? If FALSE
64-bit integers will be represented using \code{bit64::integer64}.}

\item{...}{Parameters that will be used to render the SQL.}
}
\value{
A data frame.
}
\description{
This function renders, and translates SQL, sends it to the server, and returns the results as a data.frame.
}
\details{
This function calls the \code{render} and \code{translate} functions in the \code{SqlRender} package before
calling \code{\link[=querySql]{querySql()}}.
}
\examples{
\dontrun{
connectionDetails <- createConnectionDetails(
  dbms = "postgresql",
  server = "localhost",
  user = "root",
  password = "blah",
  schema = "cdm_v4"
)
conn <- connect(connectionDetails)
persons <- renderTranslatequerySql(conn,
  sql = "SELECT TOP 10 * FROM @schema.person",
  schema = "cdm_synpuf"
)
disconnect(conn)
}
}
