% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\name{dbRemoveTable,DatabaseConnectorConnection,ANY-method}
\alias{dbRemoveTable,DatabaseConnectorConnection,ANY-method}
\title{Remove a table from the database}
\usage{
\S4method{dbRemoveTable}{DatabaseConnectorConnection,ANY}(
  conn,
  name,
  databaseSchema = NULL,
  oracleTempSchema = NULL,
  tempEmulationSchema = getOption("sqlRenderTempEmulationSchema"),
  ...
)
}
\arguments{
\item{conn}{A \link[DBI:DBIConnection-class]{DBIConnection} object, as returned by
\code{\link[DBI:dbConnect]{dbConnect()}}.}

\item{name}{The table name, passed on to \code{\link[DBI:dbQuoteIdentifier]{dbQuoteIdentifier()}}. Options are:
\itemize{
\item a character string with the unquoted DBMS table name,
e.g. \code{"table_name"},
\item a call to \code{\link[DBI:Id]{Id()}} with components to the fully qualified table name,
e.g. \code{Id(schema = "my_schema", table = "table_name")}
\item a call to \code{\link[DBI:SQL]{SQL()}} with the quoted and fully qualified table name
given verbatim, e.g. \code{SQL('"my_schema"."table_name"')}
}}

\item{databaseSchema}{The name of the database schema. See details for platform-specific details.}

\item{oracleTempSchema}{DEPRECATED: use \code{tempEmulationSchema} instead.}

\item{tempEmulationSchema}{Some database platforms like Oracle and Impala do not truly support temp tables. To
emulate temp tables, provide a schema with write privileges where temp tables
can be created.}

\item{...}{Other parameters passed on to methods.}
}
\value{
\code{dbRemoveTable()} returns \code{TRUE}, invisibly.
}
\description{
Remove a remote table (e.g., created by \code{\link[DBI:dbWriteTable]{dbWriteTable()}})
from the database.

}
\details{
The \code{databaseSchema} argument is interpreted differently according to the different platforms:
SQL Server and PDW: The databaseSchema schema should specify both the database and the schema, e.g.
'my_database.dbo'. Impala: the databaseSchema should specify the database. Oracle:
The databaseSchema should specify the Oracle 'user'. All other : The databaseSchema should
specify the schema.
}
\seealso{
Other DBIConnection generics: 
\code{\link[DBI]{DBIConnection-class}},
\code{\link[DBI]{dbAppendTable}()},
\code{\link[DBI]{dbAppendTableArrow}()},
\code{\link[DBI]{dbCreateTable}()},
\code{\link[DBI]{dbCreateTableArrow}()},
\code{\link[DBI]{dbDataType}()},
\code{\link[DBI]{dbDisconnect}()},
\code{\link[DBI]{dbExecute}()},
\code{\link[DBI]{dbExistsTable}()},
\code{\link[DBI]{dbGetException}()},
\code{\link[DBI]{dbGetInfo}()},
\code{\link[DBI]{dbGetQuery}()},
\code{\link[DBI]{dbGetQueryArrow}()},
\code{\link[DBI]{dbIsReadOnly}()},
\code{\link[DBI]{dbIsValid}()},
\code{\link[DBI]{dbListFields}()},
\code{\link[DBI]{dbListObjects}()},
\code{\link[DBI]{dbListResults}()},
\code{\link[DBI]{dbListTables}()},
\code{\link[DBI]{dbQuoteIdentifier}()},
\code{\link[DBI]{dbReadTable}()},
\code{\link[DBI]{dbReadTableArrow}()},
\code{\link[DBI]{dbSendQuery}()},
\code{\link[DBI]{dbSendQueryArrow}()},
\code{\link[DBI]{dbSendStatement}()},
\code{\link[DBI]{dbUnquoteIdentifier}()},
\code{\link[DBI]{dbWriteTable}()},
\code{\link[DBI]{dbWriteTableArrow}()}
}
