% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_bar.r
\name{plot_bar}
\alias{plot_bar}
\title{Plot bar chart}
\usage{
plot_bar(
  data,
  with = NULL,
  by = NULL,
  by_position = "fill",
  maxcat = 50,
  order_bar = TRUE,
  binary_as_factor = TRUE,
  title = NULL,
  ggtheme = theme_gray(),
  theme_config = list(),
  nrow = 3L,
  ncol = 3L,
  parallel = FALSE
)
}
\arguments{
\item{data}{input data}

\item{with}{name of continuous feature to be summed. Default is \code{NULL}, i.e., frequency.}

\item{by}{discrete feature name to be broken down by.}

\item{by_position}{position argument in \link{geom_bar} if \code{by} is supplied. Default is \code{"fill"}.}

\item{maxcat}{maximum categories allowed for each feature. Default is 50.}

\item{order_bar}{logical, indicating if bars should be ordered. Default is \code{TRUE}.}

\item{binary_as_factor}{treat binary as categorical? Default is \code{TRUE}.}

\item{title}{plot title}

\item{ggtheme}{complete ggplot2 themes. Default is \link{theme_gray}.}

\item{theme_config}{a list of configurations to be passed to \link{theme}}

\item{nrow}{number of rows per page. Default is 3.}

\item{ncol}{number of columns per page. Default is 3.}

\item{parallel}{enable parallel? Default is \code{FALSE}.}
}
\value{
invisibly return the named list of ggplot objects
}
\description{
Plot bar chart for each discrete feature, based on either frequency or another continuous feature.
}
\details{
If a discrete feature contains more categories than \code{maxcat} specifies, it will not be passed to the plotting function.
}
\examples{
# Plot bar charts for diamonds dataset
library(ggplot2)
plot_bar(diamonds)
plot_bar(diamonds, maxcat = 5)

# Plot bar charts with `price`
plot_bar(diamonds, with = "price")

# Plot bar charts by `cut`
plot_bar(diamonds, by = "cut")
plot_bar(diamonds, by = "cut", by_position = "dodge")
}
\keyword{plot_bar}
