% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gosset_Welch.R
\name{Gosset_Welch}
\alias{Gosset_Welch}
\title{Two-Sample Student's \eqn{t} and Welch–Satterthwaite Equation}
\usage{
Gosset_Welch(s1, s2, v1 = s1^2, v2 = s2^2, n1, n2, var.equal = FALSE)
}
\arguments{
\item{s1, s2}{(optional) \link[base]{double} vectors, sample standard deviation(s) of the two samples}

\item{v1, v2}{\link[base]{double} vectors, sample variances(s) of the two samples, 
default \eqn{v_1=s_1^2}, \eqn{v_2=s_2^2}.}

\item{n1, n2}{\link[base]{integer} vectors, sample size(s) of the two samples}

\item{var.equal}{\link[base]{logical} scalar, whether to treat the two variances as being equal 
(default \code{FALSE}).  See \code{\link[stats]{t.test}}}
}
\value{
\code{\link{Gosset_Welch}} returns the degree of freedom of two-sample t-test, 
with attribute \code{'stderr'} of the standard error of the mean-difference.
}
\description{
..
}
\details{
If \code{var.equal = TRUE}, the degree of freedom, as well as the standard error of the mean-difference,
are determined by equal-variances two-sample t-test, originally from William Sealy Gosset.

If \code{var.equal = FALSE}, the degree of freedom, as well as the standard error of the mean-difference,
are determined by Welch–Satterthwaite equation.
}
\examples{
x = rnorm(32L, sd = 1.6); y = rnorm(57L, sd = 2.1)
vx = var(x); vy = var(y); nx = length(x); ny = length(y)
t.test(x, y, var.equal = FALSE)[c('parameter', 'stderr')]
Gosset_Welch(v1 = vx, v2 = vy, n1 = nx, n2 = ny, var.equal = FALSE)
t.test(x, y, var.equal = TRUE)[c('parameter', 'stderr')]
Gosset_Welch(v1 = vx, v2 = vy, n1 = nx, n2 = ny, var.equal = TRUE)

}
\references{
Student's \eqn{t}-test, \doi{10.1093/biomet/6.1.1}.

Welch–Satterthwaite equation, \doi{10.2307/3002019} and \doi{10.1093/biomet/34.1-2.28}.
}
\seealso{
Method \code{stats:::t.test.default} of \code{\link[stats]{t.test}}
}
