% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getOptimalFeatureSet.R
\name{getOptimalFeatureSet}
\alias{getOptimalFeatureSet}
\title{Determine the optimal feature set using Density Index (DI)}
\usage{
getOptimalFeatureSet(
  filt.data,
  ordered.genes,
  elbow.pt = 25,
  k = 10,
  num.pcs = 20,
  error = 0
)
}
\arguments{
\item{filt.data}{log-transformed filtered gene-expression matrix}

\item{ordered.genes}{genes ordered after stepwise regression}

\item{elbow.pt}{Elbow point to start determining optimal feature set}

\item{k}{number of nearest neighbours for CI computation}

\item{num.pcs}{number of principal components to represent sc data. Default is 20.}

\item{error}{Acceptable error margin for kNN computation. Default is 0, but is set to 1 for large datasets.}
}
\value{
optimal set of feature genes
}
\description{
Determine the optimal feature set using Density Index (DI)
}
