% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Swrappers.R
\name{rowaggregate.DTSg}
\alias{rowaggregate.DTSg}
\alias{rowaggregate}
\alias{raggregate}
\title{Aggregate values row-wise}
\usage{
\method{rowaggregate}{DTSg}(
  x,
  resultCols,
  fun,
  ...,
  cols = self$cols(class = "numeric"),
  clone = getOption("DTSgClone")
)
}
\arguments{
\item{x}{A \code{\link{DTSg}} object (S3 method only).}

\item{resultCols}{A character vector either of length one (names of \code{fun} are
appended in the case one or more functions are provided) or the same length
as \code{fun} specifying the column names for the return values of \code{fun}.}

\item{fun}{A summary function, (named) \code{\link{list}} of summary functions or
(named) character vector specifying summary functions applied row-wise to
all the values of the specified \code{cols}. The return value(s) must be of
length one. See corresponding section for further information.}

\item{...}{Further arguments passed on to \code{fun}.}

\item{cols}{A character vector specifying the columns to apply \code{fun} to.
Another possibility is a character string containing either comma separated
column names, for example, \code{"x,y,z"}, or the start and end column separated
by a colon, for example, \code{"x:z"}.}

\item{clone}{A logical specifying if the object shall be modified in place or
if a deep clone (copy) shall be made beforehand.}
}
\value{
Returns a \code{\link{DTSg}} object.
}
\description{
Applies one or more provided summary functions row-wise to selected columns
of a \code{\link{DTSg}} object.
}
\section{Summary functions}{

Some examples for \code{fun} are as follows:
\itemize{
\item \code{\link{mean}}
\item \code{\link{list}(min = \link{min}, max = \link{max})}
\item \code{c(sd = "sd", var = "var")}
}
}

\examples{
# new DTSg object
DT <- data.table::data.table(
  date = flow$date,
  flow1 = flow$flow - abs(rnorm(nrow(flow))),
  flow2 = flow$flow,
  flow3 = flow$flow + abs(rnorm(nrow(flow)))
)
x <- DTSg$new(values = DT)

# mean and standard deviation of multiple measurements per timestamp
## R6 method
x$rowaggregate(
  resultCols = "flow",
  fun = list(mean = mean, sd = sd)
)$print()

## 'raggregate()' is a "hidden" R6 alias for 'rowaggregate()'
x$raggregate(
  resultCols = "flow",
  fun = list(mean = mean, sd = sd)
)$print()

## S3 method
print(rowaggregate(
  x = x,
  resultCols = "flow",
  fun = list(mean = mean, sd = sd)
))

}
\seealso{
\code{\link{cols}}, \code{\link{getOption}}
}
