% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Swrappers.R
\name{alter.DTSg}
\alias{alter.DTSg}
\alias{alter}
\title{Alter time series}
\usage{
\method{alter}{DTSg}(
  x,
  from = first(self$values(reference = TRUE)[[".dateTime"]]),
  to = last(self$values(reference = TRUE)[[".dateTime"]]),
  by = self$periodicity,
  rollback = TRUE,
  clone = getOption("DTSgClone"),
  na.status = self$na.status,
  ...
)
}
\arguments{
\item{x}{A \code{\link{DTSg}} object (S3 method only).}

\item{from}{A \code{\link{POSIXct}} timestamp in the same time zone as the time series
or a character string coercible to one. Specifies the new start of the time
series.}

\item{to}{A \code{\link{POSIXct}} timestamp in the same time zone as the time series or
a character string coercible to one. Specifies the new end of the time
series.}

\item{by}{Specifies the new periodicity in one of the ways the \code{by} argument
of \code{\link{seq.POSIXt}} can be specified. Must be specified for time series with
unrecognised periodicity. Time steps out of sync with the new periodicity
are dropped.}

\item{rollback}{A logical specifying if a call to \code{\link{rollback}} shall be made
when appropriate.}

\item{clone}{A logical specifying if the object shall be modified in place or
if a deep clone (copy) shall be made beforehand.}

\item{na.status}{A character string. Either \code{"explicit"}, which makes missing
timestamps explicit according to the recognised periodicity, or
\code{"implicit"}, which removes timestamps with missing values on all value
columns. Please note that \code{\link{DTSg}} objects work best with explicitly
missing values.}

\item{\dots}{Not used (S3 method only).}
}
\value{
Returns a \code{\link{DTSg}} object.
}
\description{
Shortens, lengthens, filters for a consecutive range, changes the periodicity
and/or the status of missing values of a \code{\link{DTSg}} object.
}
\examples{
# new DTSg object
x <- DTSg$new(values = flow)

# filter for the first two years
## R6 method
x$alter(
  from = "2007-01-01",
  to = "2008-12-31"
)$print()

## S3 method
print(alter(
  x = x,
  from = "2007-01-01",
  to = "2008-12-31"
))

# change periodicity to one month
## R6 method
x$alter(by = "1 month")$print()

## S3 method
print(alter(x = x, by = "1 month"))

}
\seealso{
\code{\link{getOption}}, \code{\link{subset}}, \code{\link{nas}}
}
