% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class.Constructors.R
\name{make.density}
\alias{make.density}
\title{Creates a Density object}
\usage{
make.density(region.obj, density.surface = list(), x.space, y.space,
  buffer = numeric(0), constant = NULL, density.gam = NULL, dsm = NULL,
  formula = NULL)
}
\arguments{
\item{region.obj}{the Region object in which the density grid will be created}

\item{density.surface}{Object of class \code{list}; list of 
data.frames with the columns x, y and density. There must be one 
data.frame for each strata.}

\item{x.space}{the intervals in the grid in the x direction}

\item{y.space}{the intervals in the grid in the y direction}

\item{buffer}{the width of the buffer region for generating the density grid. If not supplied DSsim will use the maximum value provided for the x.space or y.space.}

\item{constant}{a value describing a constant density across the surface.}

\item{density.gam}{\code{gam} object created using \code{mgcv}}

\item{dsm}{not currently implemented}

\item{formula}{not currently implemented}
}
\value{
object of class Density
}
\description{
The user has the option to create a grid describing the density of the 
objects and pass this in giving the x and y spacings used in the creation
of this grid. Alternatively the user can specify a constant density and x, 
y spacings and this grid will be generated automatically. The user may 
also supply a \code{mgcv gam} object and x, y spacings and the density grid will 
be created from these.
}
\examples{
                 
\dontrun{
pop.density <- make.density(region.obj = region, x.space = 10, 
 y.space = 10, constant = 0.5) 
 
pop.density <- add.hotspot(pop.density, centre = c(50, 200), 
 sigma = 100, amplitude = 0.1)
pop.density <- add.hotspot(pop.density, centre = c(500, 700), 
 sigma = 900, amplitude = 0.05)
pop.density <- add.hotspot(pop.density, centre = c(300, 100), 
 sigma = 100, amplitude = -0.15)

#New plot features
plot(pop.density)
plot(region, add = TRUE)

#Old style plotting
plot(pop.density, contours = FALSE, old.style = TRUE)
plot(region, add = TRUE)

}
}
\author{
Laura Marshall
}
\seealso{
\code{\link{make.region}}
}

