% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_wth.R
\name{read_wth}
\alias{read_wth}
\title{Reads weather input data from a single DSSAT weather file (*.WTH)}
\usage{
read_wth(file_name, col_types = NULL, col_names = NULL)
}
\arguments{
\item{file_name}{a character vector of length one that contains the name
of a single DSSAT output file}

\item{col_types}{One of NULL, a cols() specification, or a string.
See \code{\link[readr]{read_fwf}} or \code{vignette("readr")} for
more details.}

\item{col_names}{A character vector of column names; primarily
helpful for cases where there are no white spaces between column
names within the header line}
}
\value{
a tibble containing the data from the raw DSSAT file
}
\description{
Reads weather input data from a single DSSAT weather file (*.WTH)
}
\examples{

# Extract file path for sample weather file
sample_wth <- system.file('extdata','SAMPLE.WTH',package='DSSAT')

read_wth(sample_wth)

}
