% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.DMR.R
\name{predict.DMR}
\alias{predict.DMR}
\title{predict.DMR}
\usage{
\method{predict}{DMR}(object, newx, df = NULL, type = "link", ...)
}
\arguments{
\item{object}{Fitted DMR object.}

\item{newx}{Data frame of new values for X at which predictions are to be made.}

\item{df}{Number of parameters in the model for which predictions are required. Default is the entire sequence of models for df=1 to df=p.}

\item{type}{One of: link, response, class. For "gaussian" for all values of type it gives the fitted values. For "binomial" type "link" gives the linear predictors, for type "response" it gives the fitted probabilities and for type "class" it produces  the  class  label  corresponding  to  the  maximum  probability.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Vector or matrix of predictions.
}
\description{
Make predictions from a DMR object.
}
\details{
Similar to other predict methods, this function predicts fitted values from a fitted DMR object.
}
\examples{
data(miete)
ytr <- miete[1:1500,1]
Xtr <- miete[1:1500,-1]
Xte <- miete[1501:2053,-1]
m <- DMR(Xtr, ytr)
ypr <- predict(m, newx = Xte, df = 11)
}

