% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{get_shades}
\alias{get_shades}
\title{Returns shades of colours}
\usage{
get_shades(colours = c("#808080"), shades = 3)
}
\arguments{
\item{colours}{A character vector of colours recognizable by R, to produces shades of}

\item{shades}{A numeric vector giving the number of shades for each colour}
}
\value{
A list consisting of hex codes describing the shades of each colour
}
\description{
Returns shades of colours
}
\examples{
## Shades for a single colour
get_shades(c("red"))

## Shades for multiple colours
get_shades(c("red", "blue" ,"#A5F8E3", "#808080"), shades = c(2, 3, 4, 5))

## A single value for shade would imply all colours get the same number of shades
get_shades(c("red", "blue" ,"#A5F8E3", "#808080"), shades = 2)
}
