% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feedback.R
\name{feedback}
\alias{feedback}
\title{Function to feedback messages either to the user and/or to the
  console and to the logfile.}
\usage{
feedback(
  print_this = "",
  type = "Info",
  ui = FALSE,
  console = TRUE,
  logfile = TRUE,
  logjs = FALSE,
  prefix = "",
  suffix = "",
  findme = "",
  logfile_dir = tempdir(),
  headless = TRUE
)
}
\arguments{
\item{print_this}{(Optional, String, default: "")}

\item{type}{(Optional, String, default: "Info")
E.g. "Warning", "Error". Default: "Info"}

\item{ui}{(Optional, Boolean/String, default: FALSE)
If true, the message will also be printed to the user in form of a modal.
Can also be a string.}

\item{console}{(Optional, Boolean/String, default: TRUE)
If true, the message will also be printed to the console as is.
Can also be a string.}

\item{logfile}{(Optional, Boolean, default: TRUE)
If true (default) the print_this string will also be printed
to the console.}

\item{logjs}{(Optional, Boolean, default: FALSE)
If true (default: false) the print_this
string will also be printed to the javascript-console.
This only makes sense, if the gui is active.}

\item{prefix}{Prefix (Optional, String, default: "")
This is useful if print_this is an array/list.
Each entry will then be new row with this prefix.}

\item{suffix}{Suffix (Optional, String, default: "")
Same like prefix but at the end of each line.}

\item{findme}{(Optional, String, default: "")
Recommended with length 10.
String to find the message in the code.
E.g. 10-digit random hex from
\url{https://onlinerandomtools.com/generate-random-hexadecimal-numbers}}

\item{logfile_dir}{(Optional, String, default: "tempdir()")
The absolute path to folder where the logfile will be stored.}

\item{headless}{(Optional, Boolean, default: TRUE)
Indicating, if the function is run only in the console (headless = TRUE)
or on a GUI frontend (headless = FALSE).}
}
\value{
No return value, called for publishing a message.
}
\description{
This function provides the functionality to publish
  any kind of information to the user, the console and/or to the logfile.
  This might be a simple info, a warning or an error.
  The function can be used to select the output (console, ui, logfile).
  If no output is selected, the print_this string will be printed to the
  console and to logfile.
  One of these must be a string with length > 0: print_me, console, ui
}
\examples{
feedback(
  print_this = "This is an error message you can provide",
  type = "Error",
  findme = "215bb3695c",
  logfile_dir = tempdir(),
  headless = TRUE
)

}
