% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{getQuantile}
\alias{getQuantile}
\title{calculate quantiles}
\usage{
getQuantile(simulations, observed, integerResponse, method = c("PIT",
  "traditional"))
}
\arguments{
\item{simulations}{a matrix with simulations from a fitted model. Rows = observations, columns = replicate simulations}

\item{observed}{a vector with the observed data}

\item{integerResponse}{is the response integer-valued. Only has an effect for method = "traditional"}

\item{method}{the quantile randomization method used. See details}
}
\description{
calculates residual quantiles from a given simulation
}
\details{
The function calculates residual quantiles from the simulated data. For continous distributions, this will simply the the value of the ecdf.

For discrete data, there are two options implemented.

The current default (available since DHARMa 0.3.1) are probability integral transform (PIT-) residuals (Smith, 1985; Dunn & Smyth, 1996; see also see also Warton, et al., 2017).

Before DHARMa 0.3.1, a different randomization procedure was used, in which the a U(-0.5, 0.5) distribution was added on observations and simualtions for discrete distributions. For a completely discrete distribution, the two procedures should deliver equivalent results, but the second method has the disadvantage that a) one has to know if the distribution is discrete (DHARMa tries to recognize this automatically), and b) that it leads to inefficiencies for some distributions such as the the Tweedie, which are partly continous, partly discrte (see e.g. https://github.com/florianhartig/DHARMa/issues/168).
}
\references{
Smith, J. Q. "Diagnostic checks of non-standard time series models." Journal of Forecasting 4.3 (1985): 283-291.

Dunn, P.K., & Smyth, G.K. (1996). Randomized quantile residuals. Journal of Computational and Graphical Statistics 5, 236-244.

Warton, David I., Loïc Thibaut, and Yi Alice Wang. "The PIT-trap—A “model-free” bootstrap procedure for inference about regression models with discrete, multivariate responses." PloS one 12.7 (2017)
}
