% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reset.R
\name{resetDGEobj}
\alias{resetDGEobj}
\title{Reset to original data}
\usage{
resetDGEobj(dgeObj)
}
\arguments{
\item{dgeObj}{A class DGEobj created by function initDGEobj()}
}
\value{
A DGEobj
}
\description{
During a workflow, a DGEobj typically gets filtered down to remove samples
that fail QC or non-expressed genes. The resetDGEobj() function produces a new DGEobj with
the original unfiltered data. Resetting an object does not restore changes to attributes or class,
but does revert changes made with addItem() and rmItem(). Reset requires that *_orig data is still
in the DGEobj.
}
\examples{
    #example object
    exObj <- readRDS(system.file("exampleObj.RDS", package = "DGEobj"))

    # subset to first 10 rows to show reset functionality
    exObj <- exObj[c(1:10), ]

    exObj <- resetDGEobj(exObj)
    dim(exObj)

}
