% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{de_filter}
\alias{de_filter}
\title{Apply a custom fold-change filter to an aggregated data frame.}
\usage{
de_filter(master_df, metric, threshold, operator, absolute = TRUE)
}
\arguments{
\item{master_df}{An aggregated master DE dataframe as produced using create_master_res().}

\item{metric}{Metric to be used for filtering. All metrics are gene-wise calculated.  That is, for each gene in the aggregate data set,
a metric is calculated that is then used to filter the data. Valid metrics are: "max", "min", "mean", "variance", "sd".
The "max" metric is the gene-wise maximum fold-change value. The "min" metric is the gene-wise minimum fold-change value.
The "mean" metric is the gene-wise fold-change mean.  The "variance" metric is the gene-wise variance. The "sd" metric is the
gene-wise standard deviation.}

\item{threshold}{The cutoff value to use for filtering. Numeric.}

\item{operator}{Operator to apply to the filtering process.  Options are: "less", "greater".}

\item{absolute}{Use absolute values when applying filters to filter from both negative and positive ends of the fold change distribution.
Boolean. Default=TRUE.}
}
\value{
This function returns a data frame that has been filtered by the specified criteria.
}
\description{
This function allows you to filter an aggregated master result to only contain genes with fold-changes less than or greater than
a specified threshold for a given metric.  Several metrics are provided for flexibility of selection.
The use of metrics in this function makes it possible to ask questions such as, "which genes have a mean fold-change of at least 2?",
"which genes have a fold change of less than 5?", or "which genes have fold-change with a variance across all conditions of at least 10?"
}
\examples{
\dontrun{

#Prepare a result list.
res.day1 <- results(dds, contrast=c("Condition_Time", "day1_disease", "day1_control"))
res.day2 <- results(dds, contrast=c("Condition_Time", "day2_disease", "day2_control"))
res.day3 <- results(dds, contrast=c("Condition_Time", "day3_disease", "day3_control"))
myResList <- list(res.day1, res.day2, res.day3)

#Prepare an aggregate master data frame.
aggregate_df <- create_master_res(res_list=myResList, filename="master_DE.txt")

/*
 * Filter the aggregate data to contain only genes whose gene-wise maximum
 * fold-change is greater than 10. This will return genes whose gene-wise maximum
 * is > 10.
 */
de_filtered <- de_filter(master_df=aggregate_df, metric="max", threshold=10,
                          operator="greater", absolute=FALSE)


/*
 * Filter the aggregate data to contain only genes whose gene-wise minimum
 * fold-change is greater than an absoulte value of 4.  This will return genes
 * where the gene-wise minimum is < -4 and > +4.
 */
de_filtered <- de_filter(master_df=aggregate_df, metric="min", threshold=4,
                          operator="greater", absolute=TRUE)


/*
 * Filter the aggregate data to contain only genes whose gene-wise standard
 * deviation is less than an absoulte value of 2.  This will return genes
 * where the gene-wise standard deviation is > -2 and < +2.
 */
de_filtered <- de_filter(master_df=aggregate_df, metric="sd", threshold=2,
                          operator="less", absolute=TRUE)

}
}
\seealso{
\code{\link{create_master_res}}
}
\keyword{aggregate}
\keyword{filter}
\keyword{fold-change}
\keyword{sort}
\keyword{subset}
