% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster-methods.R
\name{read.DeponsRaster}
\alias{read.DeponsRaster}
\title{Reading DEPONS raster files}
\usage{
read.DeponsRaster(fname, type = "NA", landscape = "NA", crs = "NA")
}
\arguments{
\item{fname}{Filename (character), including the path to the DEPONS raster
file.}

\item{type}{The kind of data stored in the raster; c('food', 'patches',
'bathymetry', 'dtc', 'salinity', 'blocks').}

\item{landscape}{Identifier for the landscape used in the DEPONS simulations;
typically set to 'North Sea'.}

\item{crs}{CRS-object providing the map projection (see \link[sp]{CRS}).}
}
\value{
Returns a DeponsRaster object. The object inherits slots from the
  "RasterLayer" class, including "title", which is used for storing the file
  name.
}
\description{
Function  for reading raster files that have been used in DEPONS
  simulations. DEPONS rasters define amount of food available for simulated
  animals, spatial distribution of food patches, bathymetry, and distance to
  coast (dtc). The 'blocks' raster enables the user to count animals in
  specific parts of the landscape during simulations. See Nabe-Nielsen et al.
  (2018) for details regarding these files. In DEPONS 2.0 the salinity raster
  file was introduced; see TRACE document for details:
  \url{https://github.com/jacobnabe/DEPONS}
}
\references{
Nabe-Nielsen, J., van Beest, F. M., Grimm, V., Sibly, R. M.,
Teilmann, J., & Thompson, P. M. (2018). Predicting the impacts of
anthropogenic disturbances on marine populations. Conservation Letters,
11(5), e12563. \doi{10.1111/conl.12563}
}
\seealso{
\code{\link{DeponsRaster-class}}
}
