\name{dbfit}
\alias{dbfit.default}
\alias{dbfit.formula}
\alias{dbfit}
\title{
The main function for the double bootstrap method
}
\description{
This function is used to implement the double bootstrap method. It is used to yield estimates of both regression coefficients and autoregressive parameters(rho), and also the inference of them.
}
\usage{
\method{dbfit}{default}(x, y, arp, nbs = 500, nbscov = 500, 
conf = 0.95, correction = TRUE, method = "OLS", scores, ...)
}
\arguments{
  \item{x}{
the design matrix, including intercept, i.e. the first column being ones.
}
  \item{y}{
the response variable.
}
  \item{arp}{
the order of autoregressive errors.
}
  \item{nbs}{
the bootstrap size for the first bootstrap procedure. Default is 500.
}
  \item{nbscov}{
the bootstrap size for the second bootstrap procedure. Default is 500.
}
  \item{conf}{
the confidence level of CI for rho, default is 0.95.
}
  \item{correction}{
logical. Currently, ONLY works for order 1, i.e. for order > 1, this correction will not get involved. If TRUE, uses the correction for cases that the estimate of rho is 0.99. Default is TRUE.
}
  \item{method}{
the method to be used for fitting. If "OLS", uses the ordinary least square \code{lm}; If "RANK", uses the rank-based fit \code{rfit}.
}
 \item{scores}{
Default is Wilcoxon scores
}
  \item{\dots}{
additional arguments to be passed to fitting routines
}
}
\details{
Computes the double bootstrap as discussed in McKnight, McKean, and Huitema (2000). For details, see the references.
}
\value{
\item{coefficients}{
the estimates of regression coefficients based on the first bootstrap procedure
}
\item{rho1}{
the Durbin two-stage estimate of the autoregressive parameter rho
}
\item{adjar}{
the estimates of regression coefficients based on the first bootstrap procedure
}
\item{mse}{
the mean square error
}
\item{rho_CI_1}{
the first type of CI for rho, see the second reference for details.
}
\item{rho_CI_2}{
the second type of CI for rho, see the second reference for details.
}
\item{rho_CI_3}{
the third type of CI for rho, see the second reference for details.
}
\item{betacov}{
the estimate of the variance-covariance matrix of betas
}
\item{tabbeta}{
a table of point estimates, SE's, test statistics and p-values.
}
\item{flag99}{
an indicator; if 1, it indicates the original fit yields an estimate of rho to be 0.99. When the correction is requested (default), the correction procedure kicks in, and the final estimates of rho is corrected. Only valid if order 1 is specified.
}
\item{residuals}{
the residuals, that is response minus fitted values.
}
\item{fitted.values}{
the fitted mean values.
}
}
\references{
McKnight, S. D., McKean, J. W., and Huitema, B. E. (2000). A double bootstrap method
to analyze linear models with autoregressive error terms. Psychological methods,
5 (1), 87.

Shaofeng Zhang (2017). Ph.D. Dissertation.
}
\author{
Joseph W. McKean and Shaofeng Zhang
}
\seealso{
dbfit.formula
}
\examples{
# make sure the dependent package Rfit is installed
# To save users time, we set both bootstrap sizes to be 100 in this example. 
# Defaults are both 500. 

data(testdata)
# This data is generated by a two-phase design, with autoregressive order being one, 
# autoregressive coefficient being 0.6 and all regression coefficients being 0. 
# Both the first and second phase have 20 observations.

y <- testdata[,5]
x <- testdata[,1:4]
fit1 <- dbfit(x,y,1, nbs = 100, nbscov = 100) # OLS fit, default
summary(fit1) 
# Note that the CI's of autoregressive coef are not shown in the summary.
# Instead, they are attributes of model fit.
fit1$rho_CI_1

# fit2 <- dbfit(x,y,1, nbs = 100, nbscov = 100 ,method="RANK") # rank-based fit

# When fitting with autoregressive order 2, 
# the estimate of the second order autoregressive coefficient should not be significant,
# since this data is generated with order 1.

# fit3 <- dbfit(x,y,2, nbs = 100, nbscov = 100)
# fit3$rho_CI_1 # The first row is lower bounds, and second row is upper bounds

}
