% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/12-dbCreateTable.R, R/22-dbCreateTableArrow.R
\name{dbCreateTable}
\alias{dbCreateTable}
\alias{dbCreateTableArrow}
\title{Create a table in the database}
\usage{
dbCreateTable(conn, name, fields, ..., row.names = NULL, temporary = FALSE)

dbCreateTableArrow(conn, name, value, ...)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[=dbConnect]{dbConnect()}}.}

\item{name}{The table name, passed on to \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}}. Options are:
\itemize{
\item a character string with the unquoted DBMS table name,
e.g. \code{"table_name"},
\item a call to \code{\link[=Id]{Id()}} with components to the fully qualified table name,
e.g. \code{Id(schema = "my_schema", table = "table_name")}
\item a call to \code{\link[=SQL]{SQL()}} with the quoted and fully qualified table name
given verbatim, e.g. \code{SQL('"my_schema"."table_name"')}
}}

\item{fields}{Either a character vector or a data frame.

A named character vector: Names are column names, values are types.
Names are escaped with \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}}.
Field types are unescaped.

A data frame: field types are generated using
\code{\link[=dbDataType]{dbDataType()}}.}

\item{...}{Other parameters passed on to methods.}

\item{row.names}{Must be \code{NULL}.}

\item{temporary}{If \code{TRUE}, will generate a temporary table statement.}

\item{value}{An object coercible to an Arrow RecordBatchReader.}
}
\value{
\code{dbCreateTable()} returns \code{TRUE}, invisibly.
}
\description{
The default \code{dbCreateTable()} method calls \code{\link[=sqlCreateTable]{sqlCreateTable()}} and
\code{\link[=dbExecute]{dbExecute()}}.
Backends compliant to ANSI SQL 99 don't need to override it.
Backends with a different SQL syntax can override \code{sqlCreateTable()},
backends with entirely different ways to create tables need to
override this method.

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbCreateTable")}
}
\details{
The \code{row.names} argument is not supported by this method.
Process the values with \code{\link[=sqlRownamesToColumn]{sqlRownamesToColumn()}} before calling this method.

The argument order is different from the \code{sqlCreateTable()} method, the
latter will be adapted in a later release of DBI.
}
\section{Failure modes}{


If the table exists, an error is raised; the remote table remains unchanged.

An error is raised when calling this method for a closed
or invalid connection.
An error is also raised
if \code{name} cannot be processed with \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}}
or if this results in a non-scalar.
Invalid values for the \code{row.names} and \code{temporary} arguments
(non-scalars,
unsupported data types,
\code{NA},
incompatible values,
duplicate names)
also raise an error.

}

\section{Additional arguments}{


The following arguments are not part of the \code{dbCreateTable()} generic
(to improve compatibility across backends)
but are part of the DBI specification:
\itemize{
\item \code{temporary} (default: \code{FALSE})
}

They must be provided as named arguments.
See the "Specification" and "Value" sections for details on their usage.

}

\section{Specification}{


The \code{name} argument is processed as follows,
to support databases that allow non-syntactic names for their objects:
\itemize{
\item If an unquoted table name as string: \code{dbCreateTable()} will do the quoting,
perhaps by calling \code{dbQuoteIdentifier(conn, x = name)}
\item If the result of a call to \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}}: no more quoting is done
}

If the \code{temporary} argument is \code{TRUE}, the table is not available in a
second connection and is gone after reconnecting.
Not all backends support this argument.
A regular, non-temporary table is visible in a second connection,
in a pre-existing connection,
and after reconnecting to the database.

SQL keywords can be used freely in table names, column names, and data.
Quotes, commas, and spaces can also be used  for table names and column names,
if the database supports non-syntactic identifiers.

The \code{row.names} argument must be missing
or \code{NULL}, the default value.
All other values for the \code{row.names} argument
(in particular \code{TRUE},
\code{NA},
and a string)
raise an error.

}

\examples{
\dontshow{if (requireNamespace("RSQLite", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
con <- dbConnect(RSQLite::SQLite(), ":memory:")
dbCreateTable(con, "iris", iris)
dbReadTable(con, "iris")
dbDisconnect(con)
\dontshow{\}) # examplesIf}
}
\seealso{
Other DBIConnection generics: 
\code{\link{DBIConnection-class}},
\code{\link{dbAppendTable}()},
\code{\link{dbDataType}()},
\code{\link{dbDisconnect}()},
\code{\link{dbExecute}()},
\code{\link{dbExistsTable}()},
\code{\link{dbGetException}()},
\code{\link{dbGetInfo}()},
\code{\link{dbGetQuery}()},
\code{\link{dbIsReadOnly}()},
\code{\link{dbIsValid}()},
\code{\link{dbListFields}()},
\code{\link{dbListObjects}()},
\code{\link{dbListResults}()},
\code{\link{dbListTables}()},
\code{\link{dbReadTable}()},
\code{\link{dbRemoveTable}()},
\code{\link{dbSendQuery}()},
\code{\link{dbSendStatement}()},
\code{\link{dbWriteTable}()}
}
\concept{DBIConnection generics}
