\name{EvalConsNet}
\alias{EvalConsNet}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Evaluating consistency
}
\description{
Evaluates consistency of inferred networks with model pathway signature, If the consistency score is higher than expected by random chance, the consistent prior information(model pathway signature)
may be used to infer pathway activity. Output netcons will give the statistics of the consistency measurement, only if the Pval(consist) is significant, one could continue(followed by pruning network).  
}
\usage{
EvalConsNet(buildRN.o)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{buildRN.o}{Output object from function BuildRN}
}

\value{
  A list with following entries:

   \item{netcons}{Vector summarising properties of network and consistency with prior information:nG is the number of gene signatures, nE is the number of edges of relevance network generated by function BuildRN, fE is the ratio of the number of the edges of relevance network to the number of the edges between all the gene signatures,
   fconsE is the ratio of the number of edges whose sign are the same as prior information to the number of edges of relevance network, Pval(consist) is a p-value of significance which was derived as the fraction of randomisations that yielded an average connectivity larger than the observed one}
   \item{netsign}{A matrix of dimension 2 times number of edges in network comparing directionality of prior info and that in the observed data}
   \item{adj}{Inferred relevance network adjacency matrix}
   \item{s}{Gene signature}
   \item{c}{Correlations between signature genes}
}
\references{{Jiao Y, Lawler K, Patel GS, Purushotham A, Jones AF, Grigoriadis A, Ng T, Teschendorff AE. Denoising algorithm based on relevance network topology improves molecular pathway activity inference. Submitted.}

{Teschendorff AE, Gomez S, Arenas A, El-Ashry D, Schmidt M, et al. (2010) Improved prognostic classification of breast
cancer defined by antagonistic activation patterns of immune response pathway modules. BMC Cancer 10:604.}

}
\author{Andrew E Teschendorff, Yan Jiao}

\examples{
## The function is currently defined as
function(buildRN.o){

#######################################
sign.v <- buildRN.o$s;
adj.m <- buildRN.o$adj;
cor.m <- buildRN.o$c;
data.m <- buildRN.o$d;
########################################

netconsist.v <- vector(length=5);
names(netconsist.v) <- c("nG","nE","fE","fconsE","Pval(consist)");

ng <- length(sign.v);
netconsist.v[1] <- ng;
signPRIOR.v <- sign(sign.v);
signedgePRIOR.v <- rep(-1,0.5*ng*(ng-1));
ie <- 1;
for(n1 in 1:(ng-1)){
 for(n2 in (n1+1):ng){
   if(signPRIOR.v[n1]==signPRIOR.v[n2]){
     signedgePRIOR.v[ie] <- 1;
   }
   ie <- ie+1;
 }
  }

signedgeADJ.v <- rep(NA,0.5*ng*(ng-1));
ie <- 1;
for(n1 in 1:(ng-1)){
 for(n2 in (n1+1):ng){
   if(adj.m[n1,n2]==1){
    signedgeADJ.v[ie] <- sign(cor.m[n1,n2]);
   }
   ie <- ie+1;
 }
  }
edges.idx <- which(is.na(signedgeADJ.v)==FALSE);
ne <- length(edges.idx);
netconsist.v[2] <- ne;
netconsist.v[3] <- ne/(0.5*ng*(ng-1));
netconsist.v[4] <- length(which(signedgeADJ.v[edges.idx]==signedgePRIOR.v[edges.idx]))/ne;  
netsignedge.m <- rbind(signedgePRIOR.v,signedgeADJ.v);
rownames(netsignedge.m) <- c("PRIOR","ADJ");
## estimate significance of fraction of consistent edges: derive p-value
## randomly assign directionality values depending on data matrix
tmp.idx <- sample(1:nrow(data.m),min(c(1000,nrow(data.m))),replace=FALSE);
tmpC.m <- cor(t(data.m[tmp.idx,]));
w.v <- summary(factor(sign(as.vector(tmpC.m[upper.tri(tmpC.m)]))));
if(length(w.v)==1){
  w <- 1;
  }else {
  w <- w.v[2]/sum(w.v);
  }

permedgesADJ.v <- rep(NA,0.5*ng*(ng-1));
np <- 1000;
count <- 0;
for(p in 1:np){

 permedgesADJ.v[edges.idx] <- c(-1,1)[rbinom(length(edges.idx),1,w)+1];
  netconsist <- length(which(permedgesADJ.v[edges.idx]==signedgePRIOR.v[edges.idx]))/ne;   
  if(netconsist > netconsist.v[4]){  
 
   count <- count+1;
  }

  }
netconsist.v[5] <- count/np;

return(list(netcons=netconsist.v,netsign=netsignedge.m,adj=adj.m,s=sign.v,c=cor.m));
  }
  
  
  library(DARTData)

  data(data.m)
  data(sign.v)
  ### do BuildRN
  BuildRN.o <- BuildRN(data.m,sign.v,fdr=0.05) 
  EvalConsNet.o <- EvalConsNet(BuildRN.o)
### Results on consistency of inferred networks with model pathway signature
  print(EvalConsNet.o$netcons)
  
}


