% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aspect_importance.R
\name{plot_aspects_importance_grouping}
\alias{plot_aspects_importance_grouping}
\title{Function plots tree with aspect importance values}
\usage{
plot_aspects_importance_grouping(
  x,
  data,
  predict_function = predict,
  new_observation,
  N = 100,
  clust_method = "complete",
  absolute_value = FALSE,
  cumulative_max = FALSE,
  show_labels = TRUE,
  axis_lab_size = 10,
  text_size = 3
)
}
\arguments{
\item{x}{a model to be explained}

\item{data}{dataset, should be without target variable}

\item{predict_function}{predict function}

\item{new_observation}{selected observation with columns that corresponds to
variables used in the model, should be without target variable}

\item{N}{number of observations to be sampled (with replacement) from data}

\item{clust_method}{the agglomeration method to be used, see
\code{\link[stats]{hclust}} methods}

\item{absolute_value}{if TRUE, aspect importance values will be drawn as
absolute values}

\item{cumulative_max}{if TRUE, aspect importance shown on tree will be max
value of children and node aspect importance values}

\item{show_labels}{if TRUE, plot will have annotated axis Y}

\item{axis_lab_size}{size of labels on axis Y, if applicable}

\item{text_size}{size of labels annotating values of aspects importance}
}
\value{
ggplot
}
\description{
This function plots tree that shows order of feature grouping and aspect
importance values of every newly created aspect.
}
\examples{
library(DALEX)
apartments_num <- apartments[,unlist(lapply(apartments, is.numeric))]
apartments_num_lm_model <- lm(m2.price ~ ., data = apartments_num)
apartments_num_new_observation <- apartments_num[2,-1]
apartments_num_mod <- apartments_num[,-1]
plot_aspects_importance_grouping(x = apartments_num_lm_model,
data = apartments_num_mod, new_observation = apartments_num_new_observation)


}
